package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListMultipartUploadsResponse(
    uploadsList: Optional[Iterable[zio.aws.glacier.model.UploadListElement]] =
      Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse = {
    import ListMultipartUploadsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse
      .builder()
      .optionallyWith(
        uploadsList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.uploadsList)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.ListMultipartUploadsResponse.ReadOnly =
    zio.aws.glacier.model.ListMultipartUploadsResponse.wrap(buildAwsValue())
}
object ListMultipartUploadsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.ListMultipartUploadsResponse =
      zio.aws.glacier.model.ListMultipartUploadsResponse(
        uploadsList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def uploadsList
        : Optional[List[zio.aws.glacier.model.UploadListElement.ReadOnly]]
    def marker: Optional[String]
    def getUploadsList: ZIO[Any, AwsError, List[
      zio.aws.glacier.model.UploadListElement.ReadOnly
    ]] = AwsError.unwrapOptionField("uploadsList", uploadsList)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse
  ) extends zio.aws.glacier.model.ListMultipartUploadsResponse.ReadOnly {
    override val uploadsList
        : Optional[List[zio.aws.glacier.model.UploadListElement.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uploadsList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.glacier.model.UploadListElement.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.ListMultipartUploadsResponse
  ): zio.aws.glacier.model.ListMultipartUploadsResponse.ReadOnly = new Wrapper(
    impl
  )
}
