package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPartsResponse(
    multipartUploadId: Optional[String] = Optional.Absent,
    vaultARN: Optional[String] = Optional.Absent,
    archiveDescription: Optional[String] = Optional.Absent,
    partSizeInBytes: Optional[Long] = Optional.Absent,
    creationDate: Optional[String] = Optional.Absent,
    parts: Optional[Iterable[zio.aws.glacier.model.PartListElement]] =
      Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.ListPartsResponse = {
    import ListPartsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.ListPartsResponse
      .builder()
      .optionallyWith(multipartUploadId.map(value => value: java.lang.String))(
        _.multipartUploadId
      )
      .optionallyWith(vaultARN.map(value => value: java.lang.String))(
        _.vaultARN
      )
      .optionallyWith(archiveDescription.map(value => value: java.lang.String))(
        _.archiveDescription
      )
      .optionallyWith(partSizeInBytes.map(value => value: java.lang.Long))(
        _.partSizeInBytes
      )
      .optionallyWith(creationDate.map(value => value: java.lang.String))(
        _.creationDate
      )
      .optionallyWith(
        parts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parts)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.ListPartsResponse.ReadOnly =
    zio.aws.glacier.model.ListPartsResponse.wrap(buildAwsValue())
}
object ListPartsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.ListPartsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.ListPartsResponse =
      zio.aws.glacier.model.ListPartsResponse(
        multipartUploadId.map(value => value),
        vaultARN.map(value => value),
        archiveDescription.map(value => value),
        partSizeInBytes.map(value => value),
        creationDate.map(value => value),
        parts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def multipartUploadId: Optional[String]
    def vaultARN: Optional[String]
    def archiveDescription: Optional[String]
    def partSizeInBytes: Optional[Long]
    def creationDate: Optional[String]
    def parts: Optional[List[zio.aws.glacier.model.PartListElement.ReadOnly]]
    def marker: Optional[String]
    def getMultipartUploadId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("multipartUploadId", multipartUploadId)
    def getVaultARN: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vaultARN", vaultARN)
    def getArchiveDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("archiveDescription", archiveDescription)
    def getPartSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("partSizeInBytes", partSizeInBytes)
    def getCreationDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getParts: ZIO[Any, AwsError, List[
      zio.aws.glacier.model.PartListElement.ReadOnly
    ]] = AwsError.unwrapOptionField("parts", parts)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.ListPartsResponse
  ) extends zio.aws.glacier.model.ListPartsResponse.ReadOnly {
    override val multipartUploadId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.multipartUploadId())
      .map(value => value: String)
    override val vaultARN: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vaultARN())
      .map(value => value: String)
    override val archiveDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.archiveDescription())
      .map(value => value: String)
    override val partSizeInBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.partSizeInBytes())
      .map(value => value: Long)
    override val creationDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => value: String)
    override val parts
        : Optional[List[zio.aws.glacier.model.PartListElement.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.glacier.model.PartListElement.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.ListPartsResponse
  ): zio.aws.glacier.model.ListPartsResponse.ReadOnly = new Wrapper(impl)
}
