package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OutputLocation(
    s3: Optional[zio.aws.glacier.model.S3Location] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.OutputLocation = {
    import OutputLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.OutputLocation
      .builder()
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.OutputLocation.ReadOnly =
    zio.aws.glacier.model.OutputLocation.wrap(buildAwsValue())
}
object OutputLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.OutputLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.OutputLocation =
      zio.aws.glacier.model.OutputLocation(s3.map(value => value.asEditable))
    def s3: Optional[zio.aws.glacier.model.S3Location.ReadOnly]
    def getS3: ZIO[Any, AwsError, zio.aws.glacier.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("s3", s3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.OutputLocation
  ) extends zio.aws.glacier.model.OutputLocation.ReadOnly {
    override val s3: Optional[zio.aws.glacier.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3())
        .map(value => zio.aws.glacier.model.S3Location.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.OutputLocation
  ): zio.aws.glacier.model.OutputLocation.ReadOnly = new Wrapper(impl)
}
