package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PartListElement(
    rangeInBytes: Optional[String] = Optional.Absent,
    sha256TreeHash: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.PartListElement = {
    import PartListElement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.PartListElement
      .builder()
      .optionallyWith(rangeInBytes.map(value => value: java.lang.String))(
        _.rangeInBytes
      )
      .optionallyWith(sha256TreeHash.map(value => value: java.lang.String))(
        _.sha256TreeHash
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.PartListElement.ReadOnly =
    zio.aws.glacier.model.PartListElement.wrap(buildAwsValue())
}
object PartListElement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.PartListElement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.PartListElement =
      zio.aws.glacier.model.PartListElement(
        rangeInBytes.map(value => value),
        sha256TreeHash.map(value => value)
      )
    def rangeInBytes: Optional[String]
    def sha256TreeHash: Optional[String]
    def getRangeInBytes: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rangeInBytes", rangeInBytes)
    def getSha256TreeHash: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sha256TreeHash", sha256TreeHash)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.PartListElement
  ) extends zio.aws.glacier.model.PartListElement.ReadOnly {
    override val rangeInBytes: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.rangeInBytes())
      .map(value => value: String)
    override val sha256TreeHash: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sha256TreeHash())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.PartListElement
  ): zio.aws.glacier.model.PartListElement.ReadOnly = new Wrapper(impl)
}
