package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SetVaultNotificationsRequest(
    accountId: String,
    vaultName: String,
    vaultNotificationConfig: Optional[
      zio.aws.glacier.model.VaultNotificationConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.SetVaultNotificationsRequest = {
    import SetVaultNotificationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.SetVaultNotificationsRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .optionallyWith(
        vaultNotificationConfig.map(value => value.buildAwsValue())
      )(_.vaultNotificationConfig)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.SetVaultNotificationsRequest.ReadOnly =
    zio.aws.glacier.model.SetVaultNotificationsRequest.wrap(buildAwsValue())
}
object SetVaultNotificationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.SetVaultNotificationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.SetVaultNotificationsRequest =
      zio.aws.glacier.model.SetVaultNotificationsRequest(
        accountId,
        vaultName,
        vaultNotificationConfig.map(value => value.asEditable)
      )
    def accountId: String
    def vaultName: String
    def vaultNotificationConfig
        : Optional[zio.aws.glacier.model.VaultNotificationConfig.ReadOnly]
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
    def getVaultNotificationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.glacier.model.VaultNotificationConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "vaultNotificationConfig",
      vaultNotificationConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.SetVaultNotificationsRequest
  ) extends zio.aws.glacier.model.SetVaultNotificationsRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
    override val vaultNotificationConfig
        : Optional[zio.aws.glacier.model.VaultNotificationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vaultNotificationConfig())
        .map(value => zio.aws.glacier.model.VaultNotificationConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.SetVaultNotificationsRequest
  ): zio.aws.glacier.model.SetVaultNotificationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
