package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UploadArchiveRequest(
    vaultName: String,
    accountId: String,
    archiveDescription: Optional[String] = Optional.Absent,
    checksum: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.UploadArchiveRequest = {
    import UploadArchiveRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.UploadArchiveRequest
      .builder()
      .vaultName(vaultName: java.lang.String)
      .accountId(accountId: java.lang.String)
      .optionallyWith(archiveDescription.map(value => value: java.lang.String))(
        _.archiveDescription
      )
      .optionallyWith(checksum.map(value => value: java.lang.String))(
        _.checksum
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.UploadArchiveRequest.ReadOnly =
    zio.aws.glacier.model.UploadArchiveRequest.wrap(buildAwsValue())
}
object UploadArchiveRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.UploadArchiveRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.UploadArchiveRequest =
      zio.aws.glacier.model.UploadArchiveRequest(
        vaultName,
        accountId,
        archiveDescription.map(value => value),
        checksum.map(value => value)
      )
    def vaultName: String
    def accountId: String
    def archiveDescription: Optional[String]
    def checksum: Optional[String]
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getArchiveDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("archiveDescription", archiveDescription)
    def getChecksum: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("checksum", checksum)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.UploadArchiveRequest
  ) extends zio.aws.glacier.model.UploadArchiveRequest.ReadOnly {
    override val vaultName: String = impl.vaultName(): String
    override val accountId: String = impl.accountId(): String
    override val archiveDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.archiveDescription())
      .map(value => value: String)
    override val checksum: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.checksum())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.UploadArchiveRequest
  ): zio.aws.glacier.model.UploadArchiveRequest.ReadOnly = new Wrapper(impl)
}
