package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UploadMultipartPartRequest(
    accountId: String,
    vaultName: String,
    uploadId: String,
    checksum: Optional[String] = Optional.Absent,
    range: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.UploadMultipartPartRequest = {
    import UploadMultipartPartRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.UploadMultipartPartRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .uploadId(uploadId: java.lang.String)
      .optionallyWith(checksum.map(value => value: java.lang.String))(
        _.checksum
      )
      .optionallyWith(range.map(value => value: java.lang.String))(_.range)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.UploadMultipartPartRequest.ReadOnly =
    zio.aws.glacier.model.UploadMultipartPartRequest.wrap(buildAwsValue())
}
object UploadMultipartPartRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.UploadMultipartPartRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.UploadMultipartPartRequest =
      zio.aws.glacier.model.UploadMultipartPartRequest(
        accountId,
        vaultName,
        uploadId,
        checksum.map(value => value),
        range.map(value => value)
      )
    def accountId: String
    def vaultName: String
    def uploadId: String
    def checksum: Optional[String]
    def range: Optional[String]
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
    def getUploadId: ZIO[Any, Nothing, String] = ZIO.succeed(uploadId)
    def getChecksum: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("checksum", checksum)
    def getRange: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("range", range)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.UploadMultipartPartRequest
  ) extends zio.aws.glacier.model.UploadMultipartPartRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
    override val uploadId: String = impl.uploadId(): String
    override val checksum: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.checksum())
      .map(value => value: String)
    override val range: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.range())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.UploadMultipartPartRequest
  ): zio.aws.glacier.model.UploadMultipartPartRequest.ReadOnly = new Wrapper(
    impl
  )
}
