package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CSVInput(
    fileHeaderInfo: Optional[zio.aws.glacier.model.FileHeaderInfo] =
      Optional.Absent,
    comments: Optional[String] = Optional.Absent,
    quoteEscapeCharacter: Optional[String] = Optional.Absent,
    recordDelimiter: Optional[String] = Optional.Absent,
    fieldDelimiter: Optional[String] = Optional.Absent,
    quoteCharacter: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.CSVInput = {
    import CSVInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.CSVInput
      .builder()
      .optionallyWith(fileHeaderInfo.map(value => value.unwrap))(
        _.fileHeaderInfo
      )
      .optionallyWith(comments.map(value => value: java.lang.String))(
        _.comments
      )
      .optionallyWith(
        quoteEscapeCharacter.map(value => value: java.lang.String)
      )(_.quoteEscapeCharacter)
      .optionallyWith(recordDelimiter.map(value => value: java.lang.String))(
        _.recordDelimiter
      )
      .optionallyWith(fieldDelimiter.map(value => value: java.lang.String))(
        _.fieldDelimiter
      )
      .optionallyWith(quoteCharacter.map(value => value: java.lang.String))(
        _.quoteCharacter
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.CSVInput.ReadOnly =
    zio.aws.glacier.model.CSVInput.wrap(buildAwsValue())
}
object CSVInput {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.glacier.model.CSVInput] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.CSVInput =
      zio.aws.glacier.model.CSVInput(
        fileHeaderInfo.map(value => value),
        comments.map(value => value),
        quoteEscapeCharacter.map(value => value),
        recordDelimiter.map(value => value),
        fieldDelimiter.map(value => value),
        quoteCharacter.map(value => value)
      )
    def fileHeaderInfo: Optional[zio.aws.glacier.model.FileHeaderInfo]
    def comments: Optional[String]
    def quoteEscapeCharacter: Optional[String]
    def recordDelimiter: Optional[String]
    def fieldDelimiter: Optional[String]
    def quoteCharacter: Optional[String]
    def getFileHeaderInfo
        : ZIO[Any, AwsError, zio.aws.glacier.model.FileHeaderInfo] =
      AwsError.unwrapOptionField("fileHeaderInfo", fileHeaderInfo)
    def getComments: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("comments", comments)
    def getQuoteEscapeCharacter: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("quoteEscapeCharacter", quoteEscapeCharacter)
    def getRecordDelimiter: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("recordDelimiter", recordDelimiter)
    def getFieldDelimiter: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fieldDelimiter", fieldDelimiter)
    def getQuoteCharacter: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("quoteCharacter", quoteCharacter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.CSVInput
  ) extends zio.aws.glacier.model.CSVInput.ReadOnly {
    override val fileHeaderInfo
        : Optional[zio.aws.glacier.model.FileHeaderInfo] = zio.aws.core.internal
      .optionalFromNullable(impl.fileHeaderInfo())
      .map(value => zio.aws.glacier.model.FileHeaderInfo.wrap(value))
    override val comments: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.comments())
      .map(value => value: String)
    override val quoteEscapeCharacter: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.quoteEscapeCharacter())
      .map(value => value: String)
    override val recordDelimiter: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.recordDelimiter())
      .map(value => value: String)
    override val fieldDelimiter: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.fieldDelimiter())
      .map(value => value: String)
    override val quoteCharacter: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.quoteCharacter())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.CSVInput
  ): zio.aws.glacier.model.CSVInput.ReadOnly = new Wrapper(impl)
}
