package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeVaultRequest(accountId: String, vaultName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.DescribeVaultRequest = {
    import DescribeVaultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.DescribeVaultRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.DescribeVaultRequest.ReadOnly =
    zio.aws.glacier.model.DescribeVaultRequest.wrap(buildAwsValue())
}
object DescribeVaultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.DescribeVaultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.DescribeVaultRequest =
      zio.aws.glacier.model.DescribeVaultRequest(accountId, vaultName)
    def accountId: String
    def vaultName: String
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.DescribeVaultRequest
  ) extends zio.aws.glacier.model.DescribeVaultRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.DescribeVaultRequest
  ): zio.aws.glacier.model.DescribeVaultRequest.ReadOnly = new Wrapper(impl)
}
