package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVaultResponse(
    vaultARN: Optional[String] = Optional.Absent,
    vaultName: Optional[String] = Optional.Absent,
    creationDate: Optional[String] = Optional.Absent,
    lastInventoryDate: Optional[String] = Optional.Absent,
    numberOfArchives: Optional[Long] = Optional.Absent,
    sizeInBytes: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.DescribeVaultResponse = {
    import DescribeVaultResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.DescribeVaultResponse
      .builder()
      .optionallyWith(vaultARN.map(value => value: java.lang.String))(
        _.vaultARN
      )
      .optionallyWith(vaultName.map(value => value: java.lang.String))(
        _.vaultName
      )
      .optionallyWith(creationDate.map(value => value: java.lang.String))(
        _.creationDate
      )
      .optionallyWith(lastInventoryDate.map(value => value: java.lang.String))(
        _.lastInventoryDate
      )
      .optionallyWith(numberOfArchives.map(value => value: java.lang.Long))(
        _.numberOfArchives
      )
      .optionallyWith(sizeInBytes.map(value => value: java.lang.Long))(
        _.sizeInBytes
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.DescribeVaultResponse.ReadOnly =
    zio.aws.glacier.model.DescribeVaultResponse.wrap(buildAwsValue())
}
object DescribeVaultResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.DescribeVaultResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.DescribeVaultResponse =
      zio.aws.glacier.model.DescribeVaultResponse(
        vaultARN.map(value => value),
        vaultName.map(value => value),
        creationDate.map(value => value),
        lastInventoryDate.map(value => value),
        numberOfArchives.map(value => value),
        sizeInBytes.map(value => value)
      )
    def vaultARN: Optional[String]
    def vaultName: Optional[String]
    def creationDate: Optional[String]
    def lastInventoryDate: Optional[String]
    def numberOfArchives: Optional[Long]
    def sizeInBytes: Optional[Long]
    def getVaultARN: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vaultARN", vaultARN)
    def getVaultName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vaultName", vaultName)
    def getCreationDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastInventoryDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastInventoryDate", lastInventoryDate)
    def getNumberOfArchives: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("numberOfArchives", numberOfArchives)
    def getSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("sizeInBytes", sizeInBytes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.DescribeVaultResponse
  ) extends zio.aws.glacier.model.DescribeVaultResponse.ReadOnly {
    override val vaultARN: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vaultARN())
      .map(value => value: String)
    override val vaultName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vaultName())
      .map(value => value: String)
    override val creationDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => value: String)
    override val lastInventoryDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastInventoryDate())
      .map(value => value: String)
    override val numberOfArchives: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfArchives())
      .map(value => value: Long)
    override val sizeInBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.sizeInBytes())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.DescribeVaultResponse
  ): zio.aws.glacier.model.DescribeVaultResponse.ReadOnly = new Wrapper(impl)
}
