package zio.aws.glacier.model
import scala.jdk.CollectionConverters._
sealed trait EncryptionType {
  def unwrap: software.amazon.awssdk.services.glacier.model.EncryptionType
}
object EncryptionType {
  def wrap(
      value: software.amazon.awssdk.services.glacier.model.EncryptionType
  ): zio.aws.glacier.model.EncryptionType = value match {
    case software.amazon.awssdk.services.glacier.model.EncryptionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.glacier.model.EncryptionType.AWS_KMS =>
      val r = `aws:kms`
      r
    case software.amazon.awssdk.services.glacier.model.EncryptionType.AES256 =>
      val r = AES256
      r
  }
  case object unknownToSdkVersion extends zio.aws.glacier.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.EncryptionType =
      software.amazon.awssdk.services.glacier.model.EncryptionType.UNKNOWN_TO_SDK_VERSION
  }
  case object `aws:kms` extends zio.aws.glacier.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.EncryptionType =
      software.amazon.awssdk.services.glacier.model.EncryptionType.AWS_KMS
  }
  case object AES256 extends zio.aws.glacier.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.EncryptionType =
      software.amazon.awssdk.services.glacier.model.EncryptionType.AES256
  }
}
