package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetVaultNotificationsRequest(
    accountId: String,
    vaultName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.GetVaultNotificationsRequest = {
    import GetVaultNotificationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.GetVaultNotificationsRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.GetVaultNotificationsRequest.ReadOnly =
    zio.aws.glacier.model.GetVaultNotificationsRequest.wrap(buildAwsValue())
}
object GetVaultNotificationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.GetVaultNotificationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.GetVaultNotificationsRequest =
      zio.aws.glacier.model.GetVaultNotificationsRequest(accountId, vaultName)
    def accountId: String
    def vaultName: String
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.GetVaultNotificationsRequest
  ) extends zio.aws.glacier.model.GetVaultNotificationsRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.GetVaultNotificationsRequest
  ): zio.aws.glacier.model.GetVaultNotificationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
