package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.glacier.model.primitives.Size
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GlacierJobDescription(
    jobId: Optional[String] = Optional.Absent,
    jobDescription: Optional[String] = Optional.Absent,
    action: Optional[zio.aws.glacier.model.ActionCode] = Optional.Absent,
    archiveId: Optional[String] = Optional.Absent,
    vaultARN: Optional[String] = Optional.Absent,
    creationDate: Optional[String] = Optional.Absent,
    completed: Optional[Boolean] = Optional.Absent,
    statusCode: Optional[zio.aws.glacier.model.StatusCode] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    archiveSizeInBytes: Optional[Size] = Optional.Absent,
    inventorySizeInBytes: Optional[Size] = Optional.Absent,
    snsTopic: Optional[String] = Optional.Absent,
    completionDate: Optional[String] = Optional.Absent,
    sha256TreeHash: Optional[String] = Optional.Absent,
    archiveSHA256TreeHash: Optional[String] = Optional.Absent,
    retrievalByteRange: Optional[String] = Optional.Absent,
    tier: Optional[String] = Optional.Absent,
    inventoryRetrievalParameters: Optional[
      zio.aws.glacier.model.InventoryRetrievalJobDescription
    ] = Optional.Absent,
    jobOutputPath: Optional[String] = Optional.Absent,
    selectParameters: Optional[zio.aws.glacier.model.SelectParameters] =
      Optional.Absent,
    outputLocation: Optional[zio.aws.glacier.model.OutputLocation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.GlacierJobDescription = {
    import GlacierJobDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.GlacierJobDescription
      .builder()
      .optionallyWith(jobId.map(value => value: java.lang.String))(_.jobId)
      .optionallyWith(jobDescription.map(value => value: java.lang.String))(
        _.jobDescription
      )
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(archiveId.map(value => value: java.lang.String))(
        _.archiveId
      )
      .optionallyWith(vaultARN.map(value => value: java.lang.String))(
        _.vaultARN
      )
      .optionallyWith(creationDate.map(value => value: java.lang.String))(
        _.creationDate
      )
      .optionallyWith(completed.map(value => value: java.lang.Boolean))(
        _.completed
      )
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        archiveSizeInBytes.map(value => Size.unwrap(value): java.lang.Long)
      )(_.archiveSizeInBytes)
      .optionallyWith(
        inventorySizeInBytes.map(value => Size.unwrap(value): java.lang.Long)
      )(_.inventorySizeInBytes)
      .optionallyWith(snsTopic.map(value => value: java.lang.String))(
        _.snsTopic
      )
      .optionallyWith(completionDate.map(value => value: java.lang.String))(
        _.completionDate
      )
      .optionallyWith(sha256TreeHash.map(value => value: java.lang.String))(
        _.sha256TreeHash
      )
      .optionallyWith(
        archiveSHA256TreeHash.map(value => value: java.lang.String)
      )(_.archiveSHA256TreeHash)
      .optionallyWith(retrievalByteRange.map(value => value: java.lang.String))(
        _.retrievalByteRange
      )
      .optionallyWith(tier.map(value => value: java.lang.String))(_.tier)
      .optionallyWith(
        inventoryRetrievalParameters.map(value => value.buildAwsValue())
      )(_.inventoryRetrievalParameters)
      .optionallyWith(jobOutputPath.map(value => value: java.lang.String))(
        _.jobOutputPath
      )
      .optionallyWith(selectParameters.map(value => value.buildAwsValue()))(
        _.selectParameters
      )
      .optionallyWith(outputLocation.map(value => value.buildAwsValue()))(
        _.outputLocation
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.GlacierJobDescription.ReadOnly =
    zio.aws.glacier.model.GlacierJobDescription.wrap(buildAwsValue())
}
object GlacierJobDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.GlacierJobDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.GlacierJobDescription =
      zio.aws.glacier.model.GlacierJobDescription(
        jobId.map(value => value),
        jobDescription.map(value => value),
        action.map(value => value),
        archiveId.map(value => value),
        vaultARN.map(value => value),
        creationDate.map(value => value),
        completed.map(value => value),
        statusCode.map(value => value),
        statusMessage.map(value => value),
        archiveSizeInBytes.map(value => value),
        inventorySizeInBytes.map(value => value),
        snsTopic.map(value => value),
        completionDate.map(value => value),
        sha256TreeHash.map(value => value),
        archiveSHA256TreeHash.map(value => value),
        retrievalByteRange.map(value => value),
        tier.map(value => value),
        inventoryRetrievalParameters.map(value => value.asEditable),
        jobOutputPath.map(value => value),
        selectParameters.map(value => value.asEditable),
        outputLocation.map(value => value.asEditable)
      )
    def jobId: Optional[String]
    def jobDescription: Optional[String]
    def action: Optional[zio.aws.glacier.model.ActionCode]
    def archiveId: Optional[String]
    def vaultARN: Optional[String]
    def creationDate: Optional[String]
    def completed: Optional[Boolean]
    def statusCode: Optional[zio.aws.glacier.model.StatusCode]
    def statusMessage: Optional[String]
    def archiveSizeInBytes: Optional[Size]
    def inventorySizeInBytes: Optional[Size]
    def snsTopic: Optional[String]
    def completionDate: Optional[String]
    def sha256TreeHash: Optional[String]
    def archiveSHA256TreeHash: Optional[String]
    def retrievalByteRange: Optional[String]
    def tier: Optional[String]
    def inventoryRetrievalParameters: Optional[
      zio.aws.glacier.model.InventoryRetrievalJobDescription.ReadOnly
    ]
    def jobOutputPath: Optional[String]
    def selectParameters
        : Optional[zio.aws.glacier.model.SelectParameters.ReadOnly]
    def outputLocation: Optional[zio.aws.glacier.model.OutputLocation.ReadOnly]
    def getJobId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobDescription", jobDescription)
    def getAction: ZIO[Any, AwsError, zio.aws.glacier.model.ActionCode] =
      AwsError.unwrapOptionField("action", action)
    def getArchiveId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("archiveId", archiveId)
    def getVaultARN: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vaultARN", vaultARN)
    def getCreationDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getCompleted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("completed", completed)
    def getStatusCode: ZIO[Any, AwsError, zio.aws.glacier.model.StatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getArchiveSizeInBytes: ZIO[Any, AwsError, Size] =
      AwsError.unwrapOptionField("archiveSizeInBytes", archiveSizeInBytes)
    def getInventorySizeInBytes: ZIO[Any, AwsError, Size] =
      AwsError.unwrapOptionField("inventorySizeInBytes", inventorySizeInBytes)
    def getSnsTopic: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopic", snsTopic)
    def getCompletionDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("completionDate", completionDate)
    def getSha256TreeHash: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sha256TreeHash", sha256TreeHash)
    def getArchiveSHA256TreeHash: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("archiveSHA256TreeHash", archiveSHA256TreeHash)
    def getRetrievalByteRange: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("retrievalByteRange", retrievalByteRange)
    def getTier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tier", tier)
    def getInventoryRetrievalParameters: ZIO[
      Any,
      AwsError,
      zio.aws.glacier.model.InventoryRetrievalJobDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inventoryRetrievalParameters",
      inventoryRetrievalParameters
    )
    def getJobOutputPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobOutputPath", jobOutputPath)
    def getSelectParameters
        : ZIO[Any, AwsError, zio.aws.glacier.model.SelectParameters.ReadOnly] =
      AwsError.unwrapOptionField("selectParameters", selectParameters)
    def getOutputLocation
        : ZIO[Any, AwsError, zio.aws.glacier.model.OutputLocation.ReadOnly] =
      AwsError.unwrapOptionField("outputLocation", outputLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.GlacierJobDescription
  ) extends zio.aws.glacier.model.GlacierJobDescription.ReadOnly {
    override val jobId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => value: String)
    override val jobDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.jobDescription())
      .map(value => value: String)
    override val action: Optional[zio.aws.glacier.model.ActionCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.glacier.model.ActionCode.wrap(value))
    override val archiveId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.archiveId())
      .map(value => value: String)
    override val vaultARN: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vaultARN())
      .map(value => value: String)
    override val creationDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => value: String)
    override val completed: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.completed())
      .map(value => value: Boolean)
    override val statusCode: Optional[zio.aws.glacier.model.StatusCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusCode())
        .map(value => zio.aws.glacier.model.StatusCode.wrap(value))
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val archiveSizeInBytes: Optional[Size] = zio.aws.core.internal
      .optionalFromNullable(impl.archiveSizeInBytes())
      .map(value => zio.aws.glacier.model.primitives.Size(value))
    override val inventorySizeInBytes: Optional[Size] = zio.aws.core.internal
      .optionalFromNullable(impl.inventorySizeInBytes())
      .map(value => zio.aws.glacier.model.primitives.Size(value))
    override val snsTopic: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopic())
      .map(value => value: String)
    override val completionDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.completionDate())
      .map(value => value: String)
    override val sha256TreeHash: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sha256TreeHash())
      .map(value => value: String)
    override val archiveSHA256TreeHash: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.archiveSHA256TreeHash())
      .map(value => value: String)
    override val retrievalByteRange: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.retrievalByteRange())
      .map(value => value: String)
    override val tier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tier())
      .map(value => value: String)
    override val inventoryRetrievalParameters: Optional[
      zio.aws.glacier.model.InventoryRetrievalJobDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inventoryRetrievalParameters())
      .map(value =>
        zio.aws.glacier.model.InventoryRetrievalJobDescription.wrap(value)
      )
    override val jobOutputPath: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.jobOutputPath())
      .map(value => value: String)
    override val selectParameters
        : Optional[zio.aws.glacier.model.SelectParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.selectParameters())
        .map(value => zio.aws.glacier.model.SelectParameters.wrap(value))
    override val outputLocation
        : Optional[zio.aws.glacier.model.OutputLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputLocation())
        .map(value => zio.aws.glacier.model.OutputLocation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.GlacierJobDescription
  ): zio.aws.glacier.model.GlacierJobDescription.ReadOnly = new Wrapper(impl)
}
