package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InitiateJobResponse(
    location: Optional[String] = Optional.Absent,
    jobId: Optional[String] = Optional.Absent,
    jobOutputPath: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.InitiateJobResponse = {
    import InitiateJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.InitiateJobResponse
      .builder()
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(jobId.map(value => value: java.lang.String))(_.jobId)
      .optionallyWith(jobOutputPath.map(value => value: java.lang.String))(
        _.jobOutputPath
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.InitiateJobResponse.ReadOnly =
    zio.aws.glacier.model.InitiateJobResponse.wrap(buildAwsValue())
}
object InitiateJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.InitiateJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.InitiateJobResponse =
      zio.aws.glacier.model.InitiateJobResponse(
        location.map(value => value),
        jobId.map(value => value),
        jobOutputPath.map(value => value)
      )
    def location: Optional[String]
    def jobId: Optional[String]
    def jobOutputPath: Optional[String]
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getJobId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobOutputPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobOutputPath", jobOutputPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.InitiateJobResponse
  ) extends zio.aws.glacier.model.InitiateJobResponse.ReadOnly {
    override val location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => value: String)
    override val jobId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => value: String)
    override val jobOutputPath: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.jobOutputPath())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.InitiateJobResponse
  ): zio.aws.glacier.model.InitiateJobResponse.ReadOnly = new Wrapper(impl)
}
