package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InitiateMultipartUploadResponse(
    location: Optional[String] = Optional.Absent,
    uploadId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadResponse = {
    import InitiateMultipartUploadResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadResponse
      .builder()
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(uploadId.map(value => value: java.lang.String))(
        _.uploadId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.glacier.model.InitiateMultipartUploadResponse.ReadOnly =
    zio.aws.glacier.model.InitiateMultipartUploadResponse.wrap(buildAwsValue())
}
object InitiateMultipartUploadResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.InitiateMultipartUploadResponse =
      zio.aws.glacier.model.InitiateMultipartUploadResponse(
        location.map(value => value),
        uploadId.map(value => value)
      )
    def location: Optional[String]
    def uploadId: Optional[String]
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getUploadId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("uploadId", uploadId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadResponse
  ) extends zio.aws.glacier.model.InitiateMultipartUploadResponse.ReadOnly {
    override val location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => value: String)
    override val uploadId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.uploadId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadResponse
  ): zio.aws.glacier.model.InitiateMultipartUploadResponse.ReadOnly =
    new Wrapper(impl)
}
