package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InputSerialization(
    csv: Optional[zio.aws.glacier.model.CSVInput] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.InputSerialization = {
    import InputSerialization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.InputSerialization
      .builder()
      .optionallyWith(csv.map(value => value.buildAwsValue()))(_.csv)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.InputSerialization.ReadOnly =
    zio.aws.glacier.model.InputSerialization.wrap(buildAwsValue())
}
object InputSerialization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.InputSerialization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.InputSerialization =
      zio.aws.glacier.model
        .InputSerialization(csv.map(value => value.asEditable))
    def csv: Optional[zio.aws.glacier.model.CSVInput.ReadOnly]
    def getCsv: ZIO[Any, AwsError, zio.aws.glacier.model.CSVInput.ReadOnly] =
      AwsError.unwrapOptionField("csv", csv)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.InputSerialization
  ) extends zio.aws.glacier.model.InputSerialization.ReadOnly {
    override val csv: Optional[zio.aws.glacier.model.CSVInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.csv())
        .map(value => zio.aws.glacier.model.CSVInput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.InputSerialization
  ): zio.aws.glacier.model.InputSerialization.ReadOnly = new Wrapper(impl)
}
