package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.glacier.model.primitives.DateTime
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InventoryRetrievalJobDescription(
    format: Optional[String] = Optional.Absent,
    startDate: Optional[DateTime] = Optional.Absent,
    endDate: Optional[DateTime] = Optional.Absent,
    limit: Optional[String] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobDescription = {
    import InventoryRetrievalJobDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobDescription
      .builder()
      .optionallyWith(format.map(value => value: java.lang.String))(_.format)
      .optionallyWith(
        startDate.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.startDate)
      .optionallyWith(
        endDate.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.endDate)
      .optionallyWith(limit.map(value => value: java.lang.String))(_.limit)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.glacier.model.InventoryRetrievalJobDescription.ReadOnly =
    zio.aws.glacier.model.InventoryRetrievalJobDescription.wrap(buildAwsValue())
}
object InventoryRetrievalJobDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.InventoryRetrievalJobDescription =
      zio.aws.glacier.model.InventoryRetrievalJobDescription(
        format.map(value => value),
        startDate.map(value => value),
        endDate.map(value => value),
        limit.map(value => value),
        marker.map(value => value)
      )
    def format: Optional[String]
    def startDate: Optional[DateTime]
    def endDate: Optional[DateTime]
    def limit: Optional[String]
    def marker: Optional[String]
    def getFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("format", format)
    def getStartDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getLimit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobDescription
  ) extends zio.aws.glacier.model.InventoryRetrievalJobDescription.ReadOnly {
    override val format: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.format())
      .map(value => value: String)
    override val startDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startDate())
      .map(value => zio.aws.glacier.model.primitives.DateTime(value))
    override val endDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endDate())
      .map(value => zio.aws.glacier.model.primitives.DateTime(value))
    override val limit: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => value: String)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.InventoryRetrievalJobDescription
  ): zio.aws.glacier.model.InventoryRetrievalJobDescription.ReadOnly =
    new Wrapper(impl)
}
