package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPartsRequest(
    accountId: String,
    vaultName: String,
    uploadId: String,
    marker: Optional[String] = Optional.Absent,
    limit: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.ListPartsRequest = {
    import ListPartsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.ListPartsRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .uploadId(uploadId: java.lang.String)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(limit.map(value => value: java.lang.String))(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.ListPartsRequest.ReadOnly =
    zio.aws.glacier.model.ListPartsRequest.wrap(buildAwsValue())
}
object ListPartsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.ListPartsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.ListPartsRequest =
      zio.aws.glacier.model.ListPartsRequest(
        accountId,
        vaultName,
        uploadId,
        marker.map(value => value),
        limit.map(value => value)
      )
    def accountId: String
    def vaultName: String
    def uploadId: String
    def marker: Optional[String]
    def limit: Optional[String]
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
    def getUploadId: ZIO[Any, Nothing, String] = ZIO.succeed(uploadId)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getLimit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.ListPartsRequest
  ) extends zio.aws.glacier.model.ListPartsRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
    override val uploadId: String = impl.uploadId(): String
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val limit: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.ListPartsRequest
  ): zio.aws.glacier.model.ListPartsRequest.ReadOnly = new Wrapper(impl)
}
