package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListProvisionedCapacityResponse(
    provisionedCapacityList: Optional[
      Iterable[zio.aws.glacier.model.ProvisionedCapacityDescription]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityResponse = {
    import ListProvisionedCapacityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityResponse
      .builder()
      .optionallyWith(
        provisionedCapacityList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisionedCapacityList)
      .build()
  }
  def asReadOnly
      : zio.aws.glacier.model.ListProvisionedCapacityResponse.ReadOnly =
    zio.aws.glacier.model.ListProvisionedCapacityResponse.wrap(buildAwsValue())
}
object ListProvisionedCapacityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.ListProvisionedCapacityResponse =
      zio.aws.glacier.model.ListProvisionedCapacityResponse(
        provisionedCapacityList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def provisionedCapacityList: Optional[
      List[zio.aws.glacier.model.ProvisionedCapacityDescription.ReadOnly]
    ]
    def getProvisionedCapacityList: ZIO[Any, AwsError, List[
      zio.aws.glacier.model.ProvisionedCapacityDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "provisionedCapacityList",
      provisionedCapacityList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityResponse
  ) extends zio.aws.glacier.model.ListProvisionedCapacityResponse.ReadOnly {
    override val provisionedCapacityList: Optional[
      List[zio.aws.glacier.model.ProvisionedCapacityDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedCapacityList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.glacier.model.ProvisionedCapacityDescription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityResponse
  ): zio.aws.glacier.model.ListProvisionedCapacityResponse.ReadOnly =
    new Wrapper(impl)
}
