package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForVaultRequest(accountId: String, vaultName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.ListTagsForVaultRequest = {
    import ListTagsForVaultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.ListTagsForVaultRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.ListTagsForVaultRequest.ReadOnly =
    zio.aws.glacier.model.ListTagsForVaultRequest.wrap(buildAwsValue())
}
object ListTagsForVaultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.ListTagsForVaultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.ListTagsForVaultRequest =
      zio.aws.glacier.model.ListTagsForVaultRequest(accountId, vaultName)
    def accountId: String
    def vaultName: String
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.ListTagsForVaultRequest
  ) extends zio.aws.glacier.model.ListTagsForVaultRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.ListTagsForVaultRequest
  ): zio.aws.glacier.model.ListTagsForVaultRequest.ReadOnly = new Wrapper(impl)
}
