package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVaultsResponse(
    vaultList: Optional[Iterable[zio.aws.glacier.model.DescribeVaultOutput]] =
      Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.ListVaultsResponse = {
    import ListVaultsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.ListVaultsResponse
      .builder()
      .optionallyWith(
        vaultList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vaultList)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.ListVaultsResponse.ReadOnly =
    zio.aws.glacier.model.ListVaultsResponse.wrap(buildAwsValue())
}
object ListVaultsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.ListVaultsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.ListVaultsResponse =
      zio.aws.glacier.model.ListVaultsResponse(
        vaultList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def vaultList
        : Optional[List[zio.aws.glacier.model.DescribeVaultOutput.ReadOnly]]
    def marker: Optional[String]
    def getVaultList: ZIO[Any, AwsError, List[
      zio.aws.glacier.model.DescribeVaultOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("vaultList", vaultList)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.ListVaultsResponse
  ) extends zio.aws.glacier.model.ListVaultsResponse.ReadOnly {
    override val vaultList
        : Optional[List[zio.aws.glacier.model.DescribeVaultOutput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vaultList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.glacier.model.DescribeVaultOutput.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.ListVaultsResponse
  ): zio.aws.glacier.model.ListVaultsResponse.ReadOnly = new Wrapper(impl)
}
