package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ProvisionedCapacityDescription(
    capacityId: Optional[String] = Optional.Absent,
    startDate: Optional[String] = Optional.Absent,
    expirationDate: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.ProvisionedCapacityDescription = {
    import ProvisionedCapacityDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.ProvisionedCapacityDescription
      .builder()
      .optionallyWith(capacityId.map(value => value: java.lang.String))(
        _.capacityId
      )
      .optionallyWith(startDate.map(value => value: java.lang.String))(
        _.startDate
      )
      .optionallyWith(expirationDate.map(value => value: java.lang.String))(
        _.expirationDate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.glacier.model.ProvisionedCapacityDescription.ReadOnly =
    zio.aws.glacier.model.ProvisionedCapacityDescription.wrap(buildAwsValue())
}
object ProvisionedCapacityDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.ProvisionedCapacityDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.ProvisionedCapacityDescription =
      zio.aws.glacier.model.ProvisionedCapacityDescription(
        capacityId.map(value => value),
        startDate.map(value => value),
        expirationDate.map(value => value)
      )
    def capacityId: Optional[String]
    def startDate: Optional[String]
    def expirationDate: Optional[String]
    def getCapacityId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("capacityId", capacityId)
    def getStartDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getExpirationDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("expirationDate", expirationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.ProvisionedCapacityDescription
  ) extends zio.aws.glacier.model.ProvisionedCapacityDescription.ReadOnly {
    override val capacityId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityId())
      .map(value => value: String)
    override val startDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.startDate())
      .map(value => value: String)
    override val expirationDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.expirationDate())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.ProvisionedCapacityDescription
  ): zio.aws.glacier.model.ProvisionedCapacityDescription.ReadOnly =
    new Wrapper(impl)
}
