package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UploadArchiveResponse(
    location: Optional[String] = Optional.Absent,
    checksum: Optional[String] = Optional.Absent,
    archiveId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.UploadArchiveResponse = {
    import UploadArchiveResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.UploadArchiveResponse
      .builder()
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(checksum.map(value => value: java.lang.String))(
        _.checksum
      )
      .optionallyWith(archiveId.map(value => value: java.lang.String))(
        _.archiveId
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.UploadArchiveResponse.ReadOnly =
    zio.aws.glacier.model.UploadArchiveResponse.wrap(buildAwsValue())
}
object UploadArchiveResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.UploadArchiveResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.UploadArchiveResponse =
      zio.aws.glacier.model.UploadArchiveResponse(
        location.map(value => value),
        checksum.map(value => value),
        archiveId.map(value => value)
      )
    def location: Optional[String]
    def checksum: Optional[String]
    def archiveId: Optional[String]
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getChecksum: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("checksum", checksum)
    def getArchiveId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("archiveId", archiveId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.UploadArchiveResponse
  ) extends zio.aws.glacier.model.UploadArchiveResponse.ReadOnly {
    override val location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => value: String)
    override val checksum: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.checksum())
      .map(value => value: String)
    override val archiveId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.archiveId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.UploadArchiveResponse
  ): zio.aws.glacier.model.UploadArchiveResponse.ReadOnly = new Wrapper(impl)
}
