package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UploadListElement(
    multipartUploadId: Optional[String] = Optional.Absent,
    vaultARN: Optional[String] = Optional.Absent,
    archiveDescription: Optional[String] = Optional.Absent,
    partSizeInBytes: Optional[Long] = Optional.Absent,
    creationDate: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.UploadListElement = {
    import UploadListElement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.UploadListElement
      .builder()
      .optionallyWith(multipartUploadId.map(value => value: java.lang.String))(
        _.multipartUploadId
      )
      .optionallyWith(vaultARN.map(value => value: java.lang.String))(
        _.vaultARN
      )
      .optionallyWith(archiveDescription.map(value => value: java.lang.String))(
        _.archiveDescription
      )
      .optionallyWith(partSizeInBytes.map(value => value: java.lang.Long))(
        _.partSizeInBytes
      )
      .optionallyWith(creationDate.map(value => value: java.lang.String))(
        _.creationDate
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.UploadListElement.ReadOnly =
    zio.aws.glacier.model.UploadListElement.wrap(buildAwsValue())
}
object UploadListElement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.UploadListElement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.UploadListElement =
      zio.aws.glacier.model.UploadListElement(
        multipartUploadId.map(value => value),
        vaultARN.map(value => value),
        archiveDescription.map(value => value),
        partSizeInBytes.map(value => value),
        creationDate.map(value => value)
      )
    def multipartUploadId: Optional[String]
    def vaultARN: Optional[String]
    def archiveDescription: Optional[String]
    def partSizeInBytes: Optional[Long]
    def creationDate: Optional[String]
    def getMultipartUploadId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("multipartUploadId", multipartUploadId)
    def getVaultARN: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vaultARN", vaultARN)
    def getArchiveDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("archiveDescription", archiveDescription)
    def getPartSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("partSizeInBytes", partSizeInBytes)
    def getCreationDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.UploadListElement
  ) extends zio.aws.glacier.model.UploadListElement.ReadOnly {
    override val multipartUploadId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.multipartUploadId())
      .map(value => value: String)
    override val vaultARN: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vaultARN())
      .map(value => value: String)
    override val archiveDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.archiveDescription())
      .map(value => value: String)
    override val partSizeInBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.partSizeInBytes())
      .map(value => value: Long)
    override val creationDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.UploadListElement
  ): zio.aws.glacier.model.UploadListElement.ReadOnly = new Wrapper(impl)
}
