package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UploadMultipartPartResponse(
    checksum: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.UploadMultipartPartResponse = {
    import UploadMultipartPartResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.UploadMultipartPartResponse
      .builder()
      .optionallyWith(checksum.map(value => value: java.lang.String))(
        _.checksum
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.UploadMultipartPartResponse.ReadOnly =
    zio.aws.glacier.model.UploadMultipartPartResponse.wrap(buildAwsValue())
}
object UploadMultipartPartResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.UploadMultipartPartResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.UploadMultipartPartResponse =
      zio.aws.glacier.model
        .UploadMultipartPartResponse(checksum.map(value => value))
    def checksum: Optional[String]
    def getChecksum: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("checksum", checksum)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.UploadMultipartPartResponse
  ) extends zio.aws.glacier.model.UploadMultipartPartResponse.ReadOnly {
    override val checksum: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.checksum())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.UploadMultipartPartResponse
  ): zio.aws.glacier.model.UploadMultipartPartResponse.ReadOnly = new Wrapper(
    impl
  )
}
