package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VaultLockPolicy(policy: Optional[String] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.VaultLockPolicy = {
    import VaultLockPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.VaultLockPolicy
      .builder()
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.VaultLockPolicy.ReadOnly =
    zio.aws.glacier.model.VaultLockPolicy.wrap(buildAwsValue())
}
object VaultLockPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.VaultLockPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.VaultLockPolicy =
      zio.aws.glacier.model.VaultLockPolicy(policy.map(value => value))
    def policy: Optional[String]
    def getPolicy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.VaultLockPolicy
  ) extends zio.aws.glacier.model.VaultLockPolicy.ReadOnly {
    override val policy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.VaultLockPolicy
  ): zio.aws.glacier.model.VaultLockPolicy.ReadOnly = new Wrapper(impl)
}
