package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VaultNotificationConfig(
    snsTopic: Optional[String] = Optional.Absent,
    events: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.VaultNotificationConfig = {
    import VaultNotificationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.VaultNotificationConfig
      .builder()
      .optionallyWith(snsTopic.map(value => value: java.lang.String))(
        _.snsTopic
      )
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.events)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.VaultNotificationConfig.ReadOnly =
    zio.aws.glacier.model.VaultNotificationConfig.wrap(buildAwsValue())
}
object VaultNotificationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.VaultNotificationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.VaultNotificationConfig =
      zio.aws.glacier.model.VaultNotificationConfig(
        snsTopic.map(value => value),
        events.map(value => value)
      )
    def snsTopic: Optional[String]
    def events: Optional[List[String]]
    def getSnsTopic: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopic", snsTopic)
    def getEvents: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("events", events)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.VaultNotificationConfig
  ) extends zio.aws.glacier.model.VaultNotificationConfig.ReadOnly {
    override val snsTopic: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopic())
      .map(value => value: String)
    override val events: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.events())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.VaultNotificationConfig
  ): zio.aws.glacier.model.VaultNotificationConfig.ReadOnly = new Wrapper(impl)
}
