package zio.aws.guardduty
import zio.aws.guardduty.model.StopMonitoringMembersResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.guardduty.model.primitives.{DetectorId, FilterName, FindingId}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.aws.guardduty.model.{
  InviteMembersRequest,
  UpdateFilterRequest,
  EnableOrganizationAdminAccountRequest,
  DisableOrganizationAdminAccountRequest,
  GetIpSetRequest,
  GetMalwareScanSettingsRequest,
  CreateThreatIntelSetRequest,
  DeleteInvitationsRequest,
  UpdatePublishingDestinationRequest,
  UpdateIpSetRequest,
  GetRemainingFreeTrialDaysRequest,
  GetMemberDetectorsRequest,
  DeleteThreatIntelSetRequest,
  CreateSampleFindingsRequest,
  ArchiveFindingsRequest,
  GetFilterRequest,
  GetMembersRequest,
  UpdateMalwareScanSettingsRequest,
  ListMembersRequest,
  DescribeMalwareScansRequest,
  ListDetectorsRequest,
  ListTagsForResourceRequest,
  GetFindingsRequest,
  DeleteIpSetRequest,
  GetThreatIntelSetRequest,
  StopMonitoringMembersRequest,
  CreatePublishingDestinationRequest,
  CreateMembersRequest,
  GetAdministratorAccountRequest,
  CreateFilterRequest,
  DeclineInvitationsRequest,
  ListOrganizationAdminAccountsRequest,
  ListFindingsRequest,
  UpdateOrganizationConfigurationRequest,
  ListFiltersRequest,
  ListInvitationsRequest,
  UpdateFindingsFeedbackRequest,
  UpdateMemberDetectorsRequest,
  StartMonitoringMembersRequest,
  DescribePublishingDestinationRequest,
  UpdateDetectorRequest,
  ListThreatIntelSetsRequest,
  UntagResourceRequest,
  ListPublishingDestinationsRequest,
  DeleteFilterRequest,
  UpdateThreatIntelSetRequest,
  AcceptAdministratorInvitationRequest,
  GetUsageStatisticsRequest,
  DeletePublishingDestinationRequest,
  GetDetectorRequest,
  DeleteMembersRequest,
  UnarchiveFindingsRequest,
  DescribeOrganizationConfigurationRequest,
  GetInvitationsCountRequest,
  DeleteDetectorRequest,
  GetFindingsStatisticsRequest,
  DisassociateFromAdministratorAccountRequest,
  TagResourceRequest,
  DisassociateMembersRequest,
  ListIpSetsRequest,
  CreateDetectorRequest,
  CreateIpSetRequest
}
import software.amazon.awssdk.services.guardduty.model.{
  AdminAccount,
  ListThreatIntelSetsResponse,
  Scan,
  GetFilterResponse,
  AcceptAdministratorInvitationResponse,
  Invitation,
  UpdateDetectorResponse,
  UpdateThreatIntelSetResponse,
  UpdateFindingsFeedbackResponse,
  UpdateIpSetResponse,
  DeclineInvitationsResponse,
  Destination,
  ListFiltersResponse,
  GetUsageStatisticsResponse,
  ListOrganizationAdminAccountsResponse,
  DeleteThreatIntelSetResponse,
  GetDetectorResponse,
  ListMembersResponse,
  GetRemainingFreeTrialDaysResponse,
  DescribePublishingDestinationResponse,
  GetIpSetResponse,
  ListIpSetsResponse,
  DescribeOrganizationConfigurationResponse,
  UpdateMalwareScanSettingsResponse,
  CreateIpSetResponse,
  DeleteInvitationsResponse,
  GetFindingsResponse,
  GetMalwareScanSettingsResponse,
  DisableOrganizationAdminAccountResponse,
  ListDetectorsResponse,
  ListPublishingDestinationsResponse,
  ListTagsForResourceResponse,
  ListFindingsResponse,
  UntagResourceResponse,
  GetMemberDetectorsResponse,
  UpdateMemberDetectorsResponse,
  DeleteIpSetResponse,
  InviteMembersResponse,
  CreateFilterResponse,
  DeleteMembersResponse,
  UpdateFilterResponse,
  CreateMembersResponse,
  GetThreatIntelSetResponse,
  GetAdministratorAccountResponse,
  UpdateOrganizationConfigurationResponse,
  CreatePublishingDestinationResponse,
  DisassociateMembersResponse,
  CreateDetectorResponse,
  GetMembersResponse,
  GetFindingsStatisticsResponse,
  CreateThreatIntelSetResponse,
  ListInvitationsResponse,
  DeletePublishingDestinationResponse,
  UpdatePublishingDestinationResponse,
  EnableOrganizationAdminAccountResponse,
  UnarchiveFindingsResponse,
  DeleteDetectorResponse,
  GetInvitationsCountResponse,
  DescribeMalwareScansResponse,
  StartMonitoringMembersResponse,
  StopMonitoringMembersResponse,
  CreateSampleFindingsResponse,
  DeleteFilterResponse,
  TagResourceResponse,
  DisassociateFromAdministratorAccountResponse,
  Member,
  ArchiveFindingsResponse
}
import zio.stream.ZStream
import software.amazon.awssdk.services.guardduty.{
  GuardDutyAsyncClientBuilder,
  GuardDutyAsyncClient
}
import scala.jdk.CollectionConverters.*
trait GuardDuty extends AspectSupport[GuardDuty] {
  val api: GuardDutyAsyncClient
  def getAdministratorAccount(request: GetAdministratorAccountRequest): IO[
    AwsError,
    zio.aws.guardduty.model.GetAdministratorAccountResponse.ReadOnly
  ]
  def updateMalwareScanSettings(request: UpdateMalwareScanSettingsRequest): IO[
    AwsError,
    zio.aws.guardduty.model.UpdateMalwareScanSettingsResponse.ReadOnly
  ]
  def deletePublishingDestination(
      request: DeletePublishingDestinationRequest
  ): IO[
    AwsError,
    zio.aws.guardduty.model.DeletePublishingDestinationResponse.ReadOnly
  ]
  def describeMalwareScans(
      request: DescribeMalwareScansRequest
  ): ZStream[Any, AwsError, zio.aws.guardduty.model.Scan.ReadOnly]
  def describeMalwareScansPaginated(
      request: DescribeMalwareScansRequest
  ): IO[AwsError, zio.aws.guardduty.model.DescribeMalwareScansResponse.ReadOnly]
  def listFindings(
      request: ListFindingsRequest
  ): ZStream[Any, AwsError, FindingId]
  def listFindingsPaginated(
      request: ListFindingsRequest
  ): IO[AwsError, zio.aws.guardduty.model.ListFindingsResponse.ReadOnly]
  def updateFindingsFeedback(request: UpdateFindingsFeedbackRequest): IO[
    AwsError,
    zio.aws.guardduty.model.UpdateFindingsFeedbackResponse.ReadOnly
  ]
  def disableOrganizationAdminAccount(
      request: DisableOrganizationAdminAccountRequest
  ): IO[
    AwsError,
    zio.aws.guardduty.model.DisableOrganizationAdminAccountResponse.ReadOnly
  ]
  def deleteDetector(
      request: DeleteDetectorRequest
  ): IO[AwsError, zio.aws.guardduty.model.DeleteDetectorResponse.ReadOnly]
  def updatePublishingDestination(
      request: UpdatePublishingDestinationRequest
  ): IO[
    AwsError,
    zio.aws.guardduty.model.UpdatePublishingDestinationResponse.ReadOnly
  ]
  def createSampleFindings(
      request: CreateSampleFindingsRequest
  ): IO[AwsError, zio.aws.guardduty.model.CreateSampleFindingsResponse.ReadOnly]
  def unarchiveFindings(
      request: UnarchiveFindingsRequest
  ): IO[AwsError, zio.aws.guardduty.model.UnarchiveFindingsResponse.ReadOnly]
  def listOrganizationAdminAccounts(
      request: ListOrganizationAdminAccountsRequest
  ): ZStream[Any, AwsError, zio.aws.guardduty.model.AdminAccount.ReadOnly]
  def listOrganizationAdminAccountsPaginated(
      request: ListOrganizationAdminAccountsRequest
  ): IO[
    AwsError,
    zio.aws.guardduty.model.ListOrganizationAdminAccountsResponse.ReadOnly
  ]
  def updateOrganizationConfiguration(
      request: UpdateOrganizationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.guardduty.model.UpdateOrganizationConfigurationResponse.ReadOnly
  ]
  def createDetector(
      request: CreateDetectorRequest
  ): IO[AwsError, zio.aws.guardduty.model.CreateDetectorResponse.ReadOnly]
  def getIPSet(
      request: GetIpSetRequest
  ): IO[AwsError, zio.aws.guardduty.model.GetIpSetResponse.ReadOnly]
  def listPublishingDestinations(
      request: ListPublishingDestinationsRequest
  ): ZStream[Any, AwsError, zio.aws.guardduty.model.Destination.ReadOnly]
  def listPublishingDestinationsPaginated(
      request: ListPublishingDestinationsRequest
  ): IO[
    AwsError,
    zio.aws.guardduty.model.ListPublishingDestinationsResponse.ReadOnly
  ]
  def deleteFilter(
      request: DeleteFilterRequest
  ): IO[AwsError, zio.aws.guardduty.model.DeleteFilterResponse.ReadOnly]
  def getFilter(
      request: GetFilterRequest
  ): IO[AwsError, zio.aws.guardduty.model.GetFilterResponse.ReadOnly]
  def describePublishingDestination(
      request: DescribePublishingDestinationRequest
  ): IO[
    AwsError,
    zio.aws.guardduty.model.DescribePublishingDestinationResponse.ReadOnly
  ]
  def deleteThreatIntelSet(
      request: DeleteThreatIntelSetRequest
  ): IO[AwsError, zio.aws.guardduty.model.DeleteThreatIntelSetResponse.ReadOnly]
  def getInvitationsCount(
      request: GetInvitationsCountRequest
  ): IO[AwsError, zio.aws.guardduty.model.GetInvitationsCountResponse.ReadOnly]
  def updateDetector(
      request: UpdateDetectorRequest
  ): IO[AwsError, zio.aws.guardduty.model.UpdateDetectorResponse.ReadOnly]
  def createIPSet(
      request: CreateIpSetRequest
  ): IO[AwsError, zio.aws.guardduty.model.CreateIpSetResponse.ReadOnly]
  def createFilter(
      request: CreateFilterRequest
  ): IO[AwsError, zio.aws.guardduty.model.CreateFilterResponse.ReadOnly]
  def disassociateMembers(
      request: DisassociateMembersRequest
  ): IO[AwsError, zio.aws.guardduty.model.DisassociateMembersResponse.ReadOnly]
  def getMemberDetectors(
      request: GetMemberDetectorsRequest
  ): IO[AwsError, zio.aws.guardduty.model.GetMemberDetectorsResponse.ReadOnly]
  def updateIPSet(
      request: UpdateIpSetRequest
  ): IO[AwsError, zio.aws.guardduty.model.UpdateIpSetResponse.ReadOnly]
  def listMembers(
      request: ListMembersRequest
  ): ZStream[Any, AwsError, zio.aws.guardduty.model.Member.ReadOnly]
  def listMembersPaginated(
      request: ListMembersRequest
  ): IO[AwsError, zio.aws.guardduty.model.ListMembersResponse.ReadOnly]
  def updateThreatIntelSet(
      request: UpdateThreatIntelSetRequest
  ): IO[AwsError, zio.aws.guardduty.model.UpdateThreatIntelSetResponse.ReadOnly]
  def stopMonitoringMembers(
      request: StopMonitoringMembersRequest
  ): IO[AwsError, ReadOnly]
  def getFindingsStatistics(request: GetFindingsStatisticsRequest): IO[
    AwsError,
    zio.aws.guardduty.model.GetFindingsStatisticsResponse.ReadOnly
  ]
  def inviteMembers(
      request: InviteMembersRequest
  ): IO[AwsError, zio.aws.guardduty.model.InviteMembersResponse.ReadOnly]
  def acceptAdministratorInvitation(
      request: AcceptAdministratorInvitationRequest
  ): IO[
    AwsError,
    zio.aws.guardduty.model.AcceptAdministratorInvitationResponse.ReadOnly
  ]
  def archiveFindings(
      request: ArchiveFindingsRequest
  ): IO[AwsError, zio.aws.guardduty.model.ArchiveFindingsResponse.ReadOnly]
  def createThreatIntelSet(
      request: CreateThreatIntelSetRequest
  ): IO[AwsError, zio.aws.guardduty.model.CreateThreatIntelSetResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.guardduty.model.UntagResourceResponse.ReadOnly]
  def getFindings(
      request: GetFindingsRequest
  ): IO[AwsError, zio.aws.guardduty.model.GetFindingsResponse.ReadOnly]
  def createMembers(
      request: CreateMembersRequest
  ): IO[AwsError, zio.aws.guardduty.model.CreateMembersResponse.ReadOnly]
  def listThreatIntelSets(
      request: ListThreatIntelSetsRequest
  ): ZStream[Any, AwsError, String]
  def listThreatIntelSetsPaginated(
      request: ListThreatIntelSetsRequest
  ): IO[AwsError, zio.aws.guardduty.model.ListThreatIntelSetsResponse.ReadOnly]
  def listFilters(
      request: ListFiltersRequest
  ): ZStream[Any, AwsError, FilterName]
  def listFiltersPaginated(
      request: ListFiltersRequest
  ): IO[AwsError, zio.aws.guardduty.model.ListFiltersResponse.ReadOnly]
  def describeOrganizationConfiguration(
      request: DescribeOrganizationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.guardduty.model.DescribeOrganizationConfigurationResponse.ReadOnly
  ]
  def getRemainingFreeTrialDays(request: GetRemainingFreeTrialDaysRequest): IO[
    AwsError,
    zio.aws.guardduty.model.GetRemainingFreeTrialDaysResponse.ReadOnly
  ]
  def listDetectors(
      request: ListDetectorsRequest
  ): ZStream[Any, AwsError, DetectorId]
  def listDetectorsPaginated(
      request: ListDetectorsRequest
  ): IO[AwsError, zio.aws.guardduty.model.ListDetectorsResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.guardduty.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.guardduty.model.TagResourceResponse.ReadOnly]
  def listInvitations(
      request: ListInvitationsRequest
  ): ZStream[Any, AwsError, zio.aws.guardduty.model.Invitation.ReadOnly]
  def listInvitationsPaginated(
      request: ListInvitationsRequest
  ): IO[AwsError, zio.aws.guardduty.model.ListInvitationsResponse.ReadOnly]
  def declineInvitations(
      request: DeclineInvitationsRequest
  ): IO[AwsError, zio.aws.guardduty.model.DeclineInvitationsResponse.ReadOnly]
  def getMalwareScanSettings(request: GetMalwareScanSettingsRequest): IO[
    AwsError,
    zio.aws.guardduty.model.GetMalwareScanSettingsResponse.ReadOnly
  ]
  def updateMemberDetectors(request: UpdateMemberDetectorsRequest): IO[
    AwsError,
    zio.aws.guardduty.model.UpdateMemberDetectorsResponse.ReadOnly
  ]
  def updateFilter(
      request: UpdateFilterRequest
  ): IO[AwsError, zio.aws.guardduty.model.UpdateFilterResponse.ReadOnly]
  def enableOrganizationAdminAccount(
      request: EnableOrganizationAdminAccountRequest
  ): IO[
    AwsError,
    zio.aws.guardduty.model.EnableOrganizationAdminAccountResponse.ReadOnly
  ]
  def startMonitoringMembers(request: StartMonitoringMembersRequest): IO[
    AwsError,
    zio.aws.guardduty.model.StartMonitoringMembersResponse.ReadOnly
  ]
  def listIPSets(request: ListIpSetsRequest): ZStream[Any, AwsError, String]
  def listIPSetsPaginated(
      request: ListIpSetsRequest
  ): IO[AwsError, zio.aws.guardduty.model.ListIpSetsResponse.ReadOnly]
  def deleteInvitations(
      request: DeleteInvitationsRequest
  ): IO[AwsError, zio.aws.guardduty.model.DeleteInvitationsResponse.ReadOnly]
  def createPublishingDestination(
      request: CreatePublishingDestinationRequest
  ): IO[
    AwsError,
    zio.aws.guardduty.model.CreatePublishingDestinationResponse.ReadOnly
  ]
  def deleteIPSet(
      request: DeleteIpSetRequest
  ): IO[AwsError, zio.aws.guardduty.model.DeleteIpSetResponse.ReadOnly]
  def getDetector(
      request: GetDetectorRequest
  ): IO[AwsError, zio.aws.guardduty.model.GetDetectorResponse.ReadOnly]
  def deleteMembers(
      request: DeleteMembersRequest
  ): IO[AwsError, zio.aws.guardduty.model.DeleteMembersResponse.ReadOnly]
  def getThreatIntelSet(
      request: GetThreatIntelSetRequest
  ): IO[AwsError, zio.aws.guardduty.model.GetThreatIntelSetResponse.ReadOnly]
  def disassociateFromAdministratorAccount(
      request: DisassociateFromAdministratorAccountRequest
  ): IO[
    AwsError,
    zio.aws.guardduty.model.DisassociateFromAdministratorAccountResponse.ReadOnly
  ]
  def getUsageStatistics(
      request: GetUsageStatisticsRequest
  ): IO[AwsError, zio.aws.guardduty.model.GetUsageStatisticsResponse.ReadOnly]
  def getMembers(
      request: GetMembersRequest
  ): IO[AwsError, zio.aws.guardduty.model.GetMembersResponse.ReadOnly]
}
object GuardDuty {
  val live: ZLayer[AwsConfig, java.lang.Throwable, GuardDuty] = customized(
    identity
  )
  def customized(
      customization: GuardDutyAsyncClientBuilder => GuardDutyAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, GuardDuty] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: GuardDutyAsyncClientBuilder => GuardDutyAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, GuardDuty] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = GuardDutyAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[GuardDutyAsyncClient, GuardDutyAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[GuardDutyAsyncClient, GuardDutyAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new GuardDutyImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class GuardDutyImpl[R](
      override val api: GuardDutyAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends GuardDuty
      with AwsServiceBase[R] {
    override val serviceName: String = "GuardDuty"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): GuardDutyImpl[R1] = new GuardDutyImpl(api, newAspect, r)
    def getAdministratorAccount(request: GetAdministratorAccountRequest): IO[
      AwsError,
      zio.aws.guardduty.model.GetAdministratorAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.GetAdministratorAccountRequest,
      GetAdministratorAccountResponse
    ]("getAdministratorAccount", api.getAdministratorAccount)(
      request.buildAwsValue()
    ).map(zio.aws.guardduty.model.GetAdministratorAccountResponse.wrap)
      .provideEnvironment(r)
    def updateMalwareScanSettings(
        request: UpdateMalwareScanSettingsRequest
    ): IO[
      AwsError,
      zio.aws.guardduty.model.UpdateMalwareScanSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.UpdateMalwareScanSettingsRequest,
      UpdateMalwareScanSettingsResponse
    ]("updateMalwareScanSettings", api.updateMalwareScanSettings)(
      request.buildAwsValue()
    ).map(zio.aws.guardduty.model.UpdateMalwareScanSettingsResponse.wrap)
      .provideEnvironment(r)
    def deletePublishingDestination(
        request: DeletePublishingDestinationRequest
    ): IO[
      AwsError,
      zio.aws.guardduty.model.DeletePublishingDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.DeletePublishingDestinationRequest,
      DeletePublishingDestinationResponse
    ]("deletePublishingDestination", api.deletePublishingDestination)(
      request.buildAwsValue()
    ).map(zio.aws.guardduty.model.DeletePublishingDestinationResponse.wrap)
      .provideEnvironment(r)
    def describeMalwareScans(
        request: DescribeMalwareScansRequest
    ): ZStream[Any, AwsError, zio.aws.guardduty.model.Scan.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansRequest,
        DescribeMalwareScansResponse,
        Scan
      ](
        "describeMalwareScans",
        api.describeMalwareScans,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.scans().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.guardduty.model.Scan.wrap(item))
        .provideEnvironment(r)
    def describeMalwareScansPaginated(request: DescribeMalwareScansRequest): IO[
      AwsError,
      zio.aws.guardduty.model.DescribeMalwareScansResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansRequest,
      DescribeMalwareScansResponse
    ]("describeMalwareScans", api.describeMalwareScans)(request.buildAwsValue())
      .map(zio.aws.guardduty.model.DescribeMalwareScansResponse.wrap)
      .provideEnvironment(r)
    def listFindings(
        request: ListFindingsRequest
    ): ZStream[Any, AwsError, FindingId] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.guardduty.model.ListFindingsRequest,
      ListFindingsResponse,
      java.lang.String
    ](
      "listFindings",
      api.listFindings,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.findingIds().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.guardduty.model.primitives.FindingId(item))
      .provideEnvironment(r)
    def listFindingsPaginated(
        request: ListFindingsRequest
    ): IO[AwsError, zio.aws.guardduty.model.ListFindingsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.ListFindingsRequest,
        ListFindingsResponse
      ]("listFindings", api.listFindings)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.ListFindingsResponse.wrap)
        .provideEnvironment(r)
    def updateFindingsFeedback(request: UpdateFindingsFeedbackRequest): IO[
      AwsError,
      zio.aws.guardduty.model.UpdateFindingsFeedbackResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.UpdateFindingsFeedbackRequest,
      UpdateFindingsFeedbackResponse
    ]("updateFindingsFeedback", api.updateFindingsFeedback)(
      request.buildAwsValue()
    ).map(zio.aws.guardduty.model.UpdateFindingsFeedbackResponse.wrap)
      .provideEnvironment(r)
    def disableOrganizationAdminAccount(
        request: DisableOrganizationAdminAccountRequest
    ): IO[
      AwsError,
      zio.aws.guardduty.model.DisableOrganizationAdminAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.DisableOrganizationAdminAccountRequest,
      DisableOrganizationAdminAccountResponse
    ]("disableOrganizationAdminAccount", api.disableOrganizationAdminAccount)(
      request.buildAwsValue()
    ).map(zio.aws.guardduty.model.DisableOrganizationAdminAccountResponse.wrap)
      .provideEnvironment(r)
    def deleteDetector(
        request: DeleteDetectorRequest
    ): IO[AwsError, zio.aws.guardduty.model.DeleteDetectorResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.DeleteDetectorRequest,
        DeleteDetectorResponse
      ]("deleteDetector", api.deleteDetector)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.DeleteDetectorResponse.wrap)
        .provideEnvironment(r)
    def updatePublishingDestination(
        request: UpdatePublishingDestinationRequest
    ): IO[
      AwsError,
      zio.aws.guardduty.model.UpdatePublishingDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.UpdatePublishingDestinationRequest,
      UpdatePublishingDestinationResponse
    ]("updatePublishingDestination", api.updatePublishingDestination)(
      request.buildAwsValue()
    ).map(zio.aws.guardduty.model.UpdatePublishingDestinationResponse.wrap)
      .provideEnvironment(r)
    def createSampleFindings(request: CreateSampleFindingsRequest): IO[
      AwsError,
      zio.aws.guardduty.model.CreateSampleFindingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.CreateSampleFindingsRequest,
      CreateSampleFindingsResponse
    ]("createSampleFindings", api.createSampleFindings)(request.buildAwsValue())
      .map(zio.aws.guardduty.model.CreateSampleFindingsResponse.wrap)
      .provideEnvironment(r)
    def unarchiveFindings(request: UnarchiveFindingsRequest): IO[
      AwsError,
      zio.aws.guardduty.model.UnarchiveFindingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.UnarchiveFindingsRequest,
      UnarchiveFindingsResponse
    ]("unarchiveFindings", api.unarchiveFindings)(request.buildAwsValue())
      .map(zio.aws.guardduty.model.UnarchiveFindingsResponse.wrap)
      .provideEnvironment(r)
    def listOrganizationAdminAccounts(
        request: ListOrganizationAdminAccountsRequest
    ): ZStream[Any, AwsError, zio.aws.guardduty.model.AdminAccount.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsRequest,
        ListOrganizationAdminAccountsResponse,
        AdminAccount
      ](
        "listOrganizationAdminAccounts",
        api.listOrganizationAdminAccounts,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.adminAccounts().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.guardduty.model.AdminAccount.wrap(item))
        .provideEnvironment(r)
    def listOrganizationAdminAccountsPaginated(
        request: ListOrganizationAdminAccountsRequest
    ): IO[
      AwsError,
      zio.aws.guardduty.model.ListOrganizationAdminAccountsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsRequest,
      ListOrganizationAdminAccountsResponse
    ]("listOrganizationAdminAccounts", api.listOrganizationAdminAccounts)(
      request.buildAwsValue()
    ).map(zio.aws.guardduty.model.ListOrganizationAdminAccountsResponse.wrap)
      .provideEnvironment(r)
    def updateOrganizationConfiguration(
        request: UpdateOrganizationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.guardduty.model.UpdateOrganizationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.UpdateOrganizationConfigurationRequest,
      UpdateOrganizationConfigurationResponse
    ]("updateOrganizationConfiguration", api.updateOrganizationConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.guardduty.model.UpdateOrganizationConfigurationResponse.wrap)
      .provideEnvironment(r)
    def createDetector(
        request: CreateDetectorRequest
    ): IO[AwsError, zio.aws.guardduty.model.CreateDetectorResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.CreateDetectorRequest,
        CreateDetectorResponse
      ]("createDetector", api.createDetector)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.CreateDetectorResponse.wrap)
        .provideEnvironment(r)
    def getIPSet(
        request: GetIpSetRequest
    ): IO[AwsError, zio.aws.guardduty.model.GetIpSetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.GetIpSetRequest,
        GetIpSetResponse
      ]("getIPSet", api.getIPSet)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.GetIpSetResponse.wrap)
        .provideEnvironment(r)
    def listPublishingDestinations(
        request: ListPublishingDestinationsRequest
    ): ZStream[Any, AwsError, zio.aws.guardduty.model.Destination.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsRequest,
        ListPublishingDestinationsResponse,
        Destination
      ](
        "listPublishingDestinations",
        api.listPublishingDestinations,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.destinations().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.guardduty.model.Destination.wrap(item))
        .provideEnvironment(r)
    def listPublishingDestinationsPaginated(
        request: ListPublishingDestinationsRequest
    ): IO[
      AwsError,
      zio.aws.guardduty.model.ListPublishingDestinationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsRequest,
      ListPublishingDestinationsResponse
    ]("listPublishingDestinations", api.listPublishingDestinations)(
      request.buildAwsValue()
    ).map(zio.aws.guardduty.model.ListPublishingDestinationsResponse.wrap)
      .provideEnvironment(r)
    def deleteFilter(
        request: DeleteFilterRequest
    ): IO[AwsError, zio.aws.guardduty.model.DeleteFilterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.DeleteFilterRequest,
        DeleteFilterResponse
      ]("deleteFilter", api.deleteFilter)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.DeleteFilterResponse.wrap)
        .provideEnvironment(r)
    def getFilter(
        request: GetFilterRequest
    ): IO[AwsError, zio.aws.guardduty.model.GetFilterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.GetFilterRequest,
        GetFilterResponse
      ]("getFilter", api.getFilter)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.GetFilterResponse.wrap)
        .provideEnvironment(r)
    def describePublishingDestination(
        request: DescribePublishingDestinationRequest
    ): IO[
      AwsError,
      zio.aws.guardduty.model.DescribePublishingDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.DescribePublishingDestinationRequest,
      DescribePublishingDestinationResponse
    ]("describePublishingDestination", api.describePublishingDestination)(
      request.buildAwsValue()
    ).map(zio.aws.guardduty.model.DescribePublishingDestinationResponse.wrap)
      .provideEnvironment(r)
    def deleteThreatIntelSet(request: DeleteThreatIntelSetRequest): IO[
      AwsError,
      zio.aws.guardduty.model.DeleteThreatIntelSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.DeleteThreatIntelSetRequest,
      DeleteThreatIntelSetResponse
    ]("deleteThreatIntelSet", api.deleteThreatIntelSet)(request.buildAwsValue())
      .map(zio.aws.guardduty.model.DeleteThreatIntelSetResponse.wrap)
      .provideEnvironment(r)
    def getInvitationsCount(request: GetInvitationsCountRequest): IO[
      AwsError,
      zio.aws.guardduty.model.GetInvitationsCountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.GetInvitationsCountRequest,
      GetInvitationsCountResponse
    ]("getInvitationsCount", api.getInvitationsCount)(request.buildAwsValue())
      .map(zio.aws.guardduty.model.GetInvitationsCountResponse.wrap)
      .provideEnvironment(r)
    def updateDetector(
        request: UpdateDetectorRequest
    ): IO[AwsError, zio.aws.guardduty.model.UpdateDetectorResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.UpdateDetectorRequest,
        UpdateDetectorResponse
      ]("updateDetector", api.updateDetector)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.UpdateDetectorResponse.wrap)
        .provideEnvironment(r)
    def createIPSet(
        request: CreateIpSetRequest
    ): IO[AwsError, zio.aws.guardduty.model.CreateIpSetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.CreateIpSetRequest,
        CreateIpSetResponse
      ]("createIPSet", api.createIPSet)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.CreateIpSetResponse.wrap)
        .provideEnvironment(r)
    def createFilter(
        request: CreateFilterRequest
    ): IO[AwsError, zio.aws.guardduty.model.CreateFilterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.CreateFilterRequest,
        CreateFilterResponse
      ]("createFilter", api.createFilter)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.CreateFilterResponse.wrap)
        .provideEnvironment(r)
    def disassociateMembers(request: DisassociateMembersRequest): IO[
      AwsError,
      zio.aws.guardduty.model.DisassociateMembersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.DisassociateMembersRequest,
      DisassociateMembersResponse
    ]("disassociateMembers", api.disassociateMembers)(request.buildAwsValue())
      .map(zio.aws.guardduty.model.DisassociateMembersResponse.wrap)
      .provideEnvironment(r)
    def getMemberDetectors(request: GetMemberDetectorsRequest): IO[
      AwsError,
      zio.aws.guardduty.model.GetMemberDetectorsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.GetMemberDetectorsRequest,
      GetMemberDetectorsResponse
    ]("getMemberDetectors", api.getMemberDetectors)(request.buildAwsValue())
      .map(zio.aws.guardduty.model.GetMemberDetectorsResponse.wrap)
      .provideEnvironment(r)
    def updateIPSet(
        request: UpdateIpSetRequest
    ): IO[AwsError, zio.aws.guardduty.model.UpdateIpSetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.UpdateIpSetRequest,
        UpdateIpSetResponse
      ]("updateIPSet", api.updateIPSet)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.UpdateIpSetResponse.wrap)
        .provideEnvironment(r)
    def listMembers(
        request: ListMembersRequest
    ): ZStream[Any, AwsError, zio.aws.guardduty.model.Member.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.guardduty.model.ListMembersRequest,
        ListMembersResponse,
        Member
      ](
        "listMembers",
        api.listMembers,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.members().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.guardduty.model.Member.wrap(item))
        .provideEnvironment(r)
    def listMembersPaginated(
        request: ListMembersRequest
    ): IO[AwsError, zio.aws.guardduty.model.ListMembersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.ListMembersRequest,
        ListMembersResponse
      ]("listMembers", api.listMembers)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.ListMembersResponse.wrap)
        .provideEnvironment(r)
    def updateThreatIntelSet(request: UpdateThreatIntelSetRequest): IO[
      AwsError,
      zio.aws.guardduty.model.UpdateThreatIntelSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.UpdateThreatIntelSetRequest,
      UpdateThreatIntelSetResponse
    ]("updateThreatIntelSet", api.updateThreatIntelSet)(request.buildAwsValue())
      .map(zio.aws.guardduty.model.UpdateThreatIntelSetResponse.wrap)
      .provideEnvironment(r)
    def stopMonitoringMembers(
        request: StopMonitoringMembersRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.StopMonitoringMembersRequest,
      StopMonitoringMembersResponse
    ]("stopMonitoringMembers", api.stopMonitoringMembers)(
      request.buildAwsValue()
    ).map(zio.aws.guardduty.model.StopMonitoringMembersResponse.wrap)
      .provideEnvironment(r)
    def getFindingsStatistics(request: GetFindingsStatisticsRequest): IO[
      AwsError,
      zio.aws.guardduty.model.GetFindingsStatisticsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.GetFindingsStatisticsRequest,
      GetFindingsStatisticsResponse
    ]("getFindingsStatistics", api.getFindingsStatistics)(
      request.buildAwsValue()
    ).map(zio.aws.guardduty.model.GetFindingsStatisticsResponse.wrap)
      .provideEnvironment(r)
    def inviteMembers(
        request: InviteMembersRequest
    ): IO[AwsError, zio.aws.guardduty.model.InviteMembersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.InviteMembersRequest,
        InviteMembersResponse
      ]("inviteMembers", api.inviteMembers)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.InviteMembersResponse.wrap)
        .provideEnvironment(r)
    def acceptAdministratorInvitation(
        request: AcceptAdministratorInvitationRequest
    ): IO[
      AwsError,
      zio.aws.guardduty.model.AcceptAdministratorInvitationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.AcceptAdministratorInvitationRequest,
      AcceptAdministratorInvitationResponse
    ]("acceptAdministratorInvitation", api.acceptAdministratorInvitation)(
      request.buildAwsValue()
    ).map(zio.aws.guardduty.model.AcceptAdministratorInvitationResponse.wrap)
      .provideEnvironment(r)
    def archiveFindings(
        request: ArchiveFindingsRequest
    ): IO[AwsError, zio.aws.guardduty.model.ArchiveFindingsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.ArchiveFindingsRequest,
        ArchiveFindingsResponse
      ]("archiveFindings", api.archiveFindings)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.ArchiveFindingsResponse.wrap)
        .provideEnvironment(r)
    def createThreatIntelSet(request: CreateThreatIntelSetRequest): IO[
      AwsError,
      zio.aws.guardduty.model.CreateThreatIntelSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetRequest,
      CreateThreatIntelSetResponse
    ]("createThreatIntelSet", api.createThreatIntelSet)(request.buildAwsValue())
      .map(zio.aws.guardduty.model.CreateThreatIntelSetResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.guardduty.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def getFindings(
        request: GetFindingsRequest
    ): IO[AwsError, zio.aws.guardduty.model.GetFindingsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.GetFindingsRequest,
        GetFindingsResponse
      ]("getFindings", api.getFindings)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.GetFindingsResponse.wrap)
        .provideEnvironment(r)
    def createMembers(
        request: CreateMembersRequest
    ): IO[AwsError, zio.aws.guardduty.model.CreateMembersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.CreateMembersRequest,
        CreateMembersResponse
      ]("createMembers", api.createMembers)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.CreateMembersResponse.wrap)
        .provideEnvironment(r)
    def listThreatIntelSets(
        request: ListThreatIntelSetsRequest
    ): ZStream[Any, AwsError, String] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest,
      ListThreatIntelSetsResponse,
      java.lang.String
    ](
      "listThreatIntelSets",
      api.listThreatIntelSets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.threatIntelSetIds().asScala)
    )(request.buildAwsValue()).map(item => item: String).provideEnvironment(r)
    def listThreatIntelSetsPaginated(request: ListThreatIntelSetsRequest): IO[
      AwsError,
      zio.aws.guardduty.model.ListThreatIntelSetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest,
      ListThreatIntelSetsResponse
    ]("listThreatIntelSets", api.listThreatIntelSets)(request.buildAwsValue())
      .map(zio.aws.guardduty.model.ListThreatIntelSetsResponse.wrap)
      .provideEnvironment(r)
    def listFilters(
        request: ListFiltersRequest
    ): ZStream[Any, AwsError, FilterName] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.guardduty.model.ListFiltersRequest,
      ListFiltersResponse,
      java.lang.String
    ](
      "listFilters",
      api.listFilters,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.filterNames().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.guardduty.model.primitives.FilterName(item))
      .provideEnvironment(r)
    def listFiltersPaginated(
        request: ListFiltersRequest
    ): IO[AwsError, zio.aws.guardduty.model.ListFiltersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.ListFiltersRequest,
        ListFiltersResponse
      ]("listFilters", api.listFilters)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.ListFiltersResponse.wrap)
        .provideEnvironment(r)
    def describeOrganizationConfiguration(
        request: DescribeOrganizationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.guardduty.model.DescribeOrganizationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationRequest,
      DescribeOrganizationConfigurationResponse
    ](
      "describeOrganizationConfiguration",
      api.describeOrganizationConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.guardduty.model.DescribeOrganizationConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def getRemainingFreeTrialDays(
        request: GetRemainingFreeTrialDaysRequest
    ): IO[
      AwsError,
      zio.aws.guardduty.model.GetRemainingFreeTrialDaysResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.GetRemainingFreeTrialDaysRequest,
      GetRemainingFreeTrialDaysResponse
    ]("getRemainingFreeTrialDays", api.getRemainingFreeTrialDays)(
      request.buildAwsValue()
    ).map(zio.aws.guardduty.model.GetRemainingFreeTrialDaysResponse.wrap)
      .provideEnvironment(r)
    def listDetectors(
        request: ListDetectorsRequest
    ): ZStream[Any, AwsError, DetectorId] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest,
      ListDetectorsResponse,
      java.lang.String
    ](
      "listDetectors",
      api.listDetectors,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.detectorIds().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.guardduty.model.primitives.DetectorId(item))
      .provideEnvironment(r)
    def listDetectorsPaginated(
        request: ListDetectorsRequest
    ): IO[AwsError, zio.aws.guardduty.model.ListDetectorsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest,
        ListDetectorsResponse
      ]("listDetectors", api.listDetectors)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.ListDetectorsResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.guardduty.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.guardduty.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.guardduty.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listInvitations(
        request: ListInvitationsRequest
    ): ZStream[Any, AwsError, zio.aws.guardduty.model.Invitation.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest,
        ListInvitationsResponse,
        Invitation
      ](
        "listInvitations",
        api.listInvitations,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.invitations().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.guardduty.model.Invitation.wrap(item))
        .provideEnvironment(r)
    def listInvitationsPaginated(
        request: ListInvitationsRequest
    ): IO[AwsError, zio.aws.guardduty.model.ListInvitationsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest,
        ListInvitationsResponse
      ]("listInvitations", api.listInvitations)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.ListInvitationsResponse.wrap)
        .provideEnvironment(r)
    def declineInvitations(request: DeclineInvitationsRequest): IO[
      AwsError,
      zio.aws.guardduty.model.DeclineInvitationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.DeclineInvitationsRequest,
      DeclineInvitationsResponse
    ]("declineInvitations", api.declineInvitations)(request.buildAwsValue())
      .map(zio.aws.guardduty.model.DeclineInvitationsResponse.wrap)
      .provideEnvironment(r)
    def getMalwareScanSettings(request: GetMalwareScanSettingsRequest): IO[
      AwsError,
      zio.aws.guardduty.model.GetMalwareScanSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.GetMalwareScanSettingsRequest,
      GetMalwareScanSettingsResponse
    ]("getMalwareScanSettings", api.getMalwareScanSettings)(
      request.buildAwsValue()
    ).map(zio.aws.guardduty.model.GetMalwareScanSettingsResponse.wrap)
      .provideEnvironment(r)
    def updateMemberDetectors(request: UpdateMemberDetectorsRequest): IO[
      AwsError,
      zio.aws.guardduty.model.UpdateMemberDetectorsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.UpdateMemberDetectorsRequest,
      UpdateMemberDetectorsResponse
    ]("updateMemberDetectors", api.updateMemberDetectors)(
      request.buildAwsValue()
    ).map(zio.aws.guardduty.model.UpdateMemberDetectorsResponse.wrap)
      .provideEnvironment(r)
    def updateFilter(
        request: UpdateFilterRequest
    ): IO[AwsError, zio.aws.guardduty.model.UpdateFilterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.UpdateFilterRequest,
        UpdateFilterResponse
      ]("updateFilter", api.updateFilter)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.UpdateFilterResponse.wrap)
        .provideEnvironment(r)
    def enableOrganizationAdminAccount(
        request: EnableOrganizationAdminAccountRequest
    ): IO[
      AwsError,
      zio.aws.guardduty.model.EnableOrganizationAdminAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.EnableOrganizationAdminAccountRequest,
      EnableOrganizationAdminAccountResponse
    ]("enableOrganizationAdminAccount", api.enableOrganizationAdminAccount)(
      request.buildAwsValue()
    ).map(zio.aws.guardduty.model.EnableOrganizationAdminAccountResponse.wrap)
      .provideEnvironment(r)
    def startMonitoringMembers(request: StartMonitoringMembersRequest): IO[
      AwsError,
      zio.aws.guardduty.model.StartMonitoringMembersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.StartMonitoringMembersRequest,
      StartMonitoringMembersResponse
    ]("startMonitoringMembers", api.startMonitoringMembers)(
      request.buildAwsValue()
    ).map(zio.aws.guardduty.model.StartMonitoringMembersResponse.wrap)
      .provideEnvironment(r)
    def listIPSets(request: ListIpSetsRequest): ZStream[Any, AwsError, String] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.guardduty.model.ListIpSetsRequest,
        ListIpSetsResponse,
        java.lang.String
      ](
        "listIPSets",
        api.listIPSets,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.ipSetIds().asScala)
      )(request.buildAwsValue()).map(item => item: String).provideEnvironment(r)
    def listIPSetsPaginated(
        request: ListIpSetsRequest
    ): IO[AwsError, zio.aws.guardduty.model.ListIpSetsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.ListIpSetsRequest,
        ListIpSetsResponse
      ]("listIPSets", api.listIPSets)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.ListIpSetsResponse.wrap)
        .provideEnvironment(r)
    def deleteInvitations(request: DeleteInvitationsRequest): IO[
      AwsError,
      zio.aws.guardduty.model.DeleteInvitationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.DeleteInvitationsRequest,
      DeleteInvitationsResponse
    ]("deleteInvitations", api.deleteInvitations)(request.buildAwsValue())
      .map(zio.aws.guardduty.model.DeleteInvitationsResponse.wrap)
      .provideEnvironment(r)
    def createPublishingDestination(
        request: CreatePublishingDestinationRequest
    ): IO[
      AwsError,
      zio.aws.guardduty.model.CreatePublishingDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.CreatePublishingDestinationRequest,
      CreatePublishingDestinationResponse
    ]("createPublishingDestination", api.createPublishingDestination)(
      request.buildAwsValue()
    ).map(zio.aws.guardduty.model.CreatePublishingDestinationResponse.wrap)
      .provideEnvironment(r)
    def deleteIPSet(
        request: DeleteIpSetRequest
    ): IO[AwsError, zio.aws.guardduty.model.DeleteIpSetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.DeleteIpSetRequest,
        DeleteIpSetResponse
      ]("deleteIPSet", api.deleteIPSet)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.DeleteIpSetResponse.wrap)
        .provideEnvironment(r)
    def getDetector(
        request: GetDetectorRequest
    ): IO[AwsError, zio.aws.guardduty.model.GetDetectorResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.GetDetectorRequest,
        GetDetectorResponse
      ]("getDetector", api.getDetector)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.GetDetectorResponse.wrap)
        .provideEnvironment(r)
    def deleteMembers(
        request: DeleteMembersRequest
    ): IO[AwsError, zio.aws.guardduty.model.DeleteMembersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.DeleteMembersRequest,
        DeleteMembersResponse
      ]("deleteMembers", api.deleteMembers)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.DeleteMembersResponse.wrap)
        .provideEnvironment(r)
    def getThreatIntelSet(request: GetThreatIntelSetRequest): IO[
      AwsError,
      zio.aws.guardduty.model.GetThreatIntelSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetRequest,
      GetThreatIntelSetResponse
    ]("getThreatIntelSet", api.getThreatIntelSet)(request.buildAwsValue())
      .map(zio.aws.guardduty.model.GetThreatIntelSetResponse.wrap)
      .provideEnvironment(r)
    def disassociateFromAdministratorAccount(
        request: DisassociateFromAdministratorAccountRequest
    ): IO[
      AwsError,
      zio.aws.guardduty.model.DisassociateFromAdministratorAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.DisassociateFromAdministratorAccountRequest,
      DisassociateFromAdministratorAccountResponse
    ](
      "disassociateFromAdministratorAccount",
      api.disassociateFromAdministratorAccount
    )(request.buildAwsValue())
      .map(
        zio.aws.guardduty.model.DisassociateFromAdministratorAccountResponse.wrap
      )
      .provideEnvironment(r)
    def getUsageStatistics(request: GetUsageStatisticsRequest): IO[
      AwsError,
      zio.aws.guardduty.model.GetUsageStatisticsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.guardduty.model.GetUsageStatisticsRequest,
      GetUsageStatisticsResponse
    ]("getUsageStatistics", api.getUsageStatistics)(request.buildAwsValue())
      .map(zio.aws.guardduty.model.GetUsageStatisticsResponse.wrap)
      .provideEnvironment(r)
    def getMembers(
        request: GetMembersRequest
    ): IO[AwsError, zio.aws.guardduty.model.GetMembersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.guardduty.model.GetMembersRequest,
        GetMembersResponse
      ]("getMembers", api.getMembers)(request.buildAwsValue())
        .map(zio.aws.guardduty.model.GetMembersResponse.wrap)
        .provideEnvironment(r)
  }
  def getAdministratorAccount(request: GetAdministratorAccountRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.GetAdministratorAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAdministratorAccount(request))
  def updateMalwareScanSettings(request: UpdateMalwareScanSettingsRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.UpdateMalwareScanSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMalwareScanSettings(request))
  def deletePublishingDestination(
      request: DeletePublishingDestinationRequest
  ): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.DeletePublishingDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePublishingDestination(request))
  def describeMalwareScans(request: DescribeMalwareScansRequest): ZStream[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.Scan.ReadOnly
  ] = ZStream.serviceWithStream(_.describeMalwareScans(request))
  def describeMalwareScansPaginated(request: DescribeMalwareScansRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.DescribeMalwareScansResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMalwareScansPaginated(request))
  def listFindings(
      request: ListFindingsRequest
  ): ZStream[zio.aws.guardduty.GuardDuty, AwsError, FindingId] =
    ZStream.serviceWithStream(_.listFindings(request))
  def listFindingsPaginated(request: ListFindingsRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.ListFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFindingsPaginated(request))
  def updateFindingsFeedback(request: UpdateFindingsFeedbackRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.UpdateFindingsFeedbackResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFindingsFeedback(request))
  def disableOrganizationAdminAccount(
      request: DisableOrganizationAdminAccountRequest
  ): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.DisableOrganizationAdminAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableOrganizationAdminAccount(request))
  def deleteDetector(request: DeleteDetectorRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.DeleteDetectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDetector(request))
  def updatePublishingDestination(
      request: UpdatePublishingDestinationRequest
  ): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.UpdatePublishingDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePublishingDestination(request))
  def createSampleFindings(request: CreateSampleFindingsRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.CreateSampleFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSampleFindings(request))
  def unarchiveFindings(request: UnarchiveFindingsRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.UnarchiveFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.unarchiveFindings(request))
  def listOrganizationAdminAccounts(
      request: ListOrganizationAdminAccountsRequest
  ): ZStream[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.AdminAccount.ReadOnly
  ] = ZStream.serviceWithStream(_.listOrganizationAdminAccounts(request))
  def listOrganizationAdminAccountsPaginated(
      request: ListOrganizationAdminAccountsRequest
  ): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.ListOrganizationAdminAccountsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOrganizationAdminAccountsPaginated(request))
  def updateOrganizationConfiguration(
      request: UpdateOrganizationConfigurationRequest
  ): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.UpdateOrganizationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateOrganizationConfiguration(request))
  def createDetector(request: CreateDetectorRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.CreateDetectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDetector(request))
  def getIPSet(request: GetIpSetRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.GetIpSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIPSet(request))
  def listPublishingDestinations(
      request: ListPublishingDestinationsRequest
  ): ZStream[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.Destination.ReadOnly
  ] = ZStream.serviceWithStream(_.listPublishingDestinations(request))
  def listPublishingDestinationsPaginated(
      request: ListPublishingDestinationsRequest
  ): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.ListPublishingDestinationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPublishingDestinationsPaginated(request))
  def deleteFilter(request: DeleteFilterRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.DeleteFilterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFilter(request))
  def getFilter(request: GetFilterRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.GetFilterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFilter(request))
  def describePublishingDestination(
      request: DescribePublishingDestinationRequest
  ): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.DescribePublishingDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePublishingDestination(request))
  def deleteThreatIntelSet(request: DeleteThreatIntelSetRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.DeleteThreatIntelSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteThreatIntelSet(request))
  def getInvitationsCount(request: GetInvitationsCountRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.GetInvitationsCountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInvitationsCount(request))
  def updateDetector(request: UpdateDetectorRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.UpdateDetectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDetector(request))
  def createIPSet(request: CreateIpSetRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.CreateIpSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createIPSet(request))
  def createFilter(request: CreateFilterRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.CreateFilterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFilter(request))
  def disassociateMembers(request: DisassociateMembersRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.DisassociateMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateMembers(request))
  def getMemberDetectors(request: GetMemberDetectorsRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.GetMemberDetectorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMemberDetectors(request))
  def updateIPSet(request: UpdateIpSetRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.UpdateIpSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateIPSet(request))
  def listMembers(request: ListMembersRequest): ZStream[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.Member.ReadOnly
  ] = ZStream.serviceWithStream(_.listMembers(request))
  def listMembersPaginated(request: ListMembersRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.ListMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMembersPaginated(request))
  def updateThreatIntelSet(request: UpdateThreatIntelSetRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.UpdateThreatIntelSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateThreatIntelSet(request))
  def stopMonitoringMembers(
      request: StopMonitoringMembersRequest
  ): ZIO[zio.aws.guardduty.GuardDuty, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.stopMonitoringMembers(request))
  def getFindingsStatistics(request: GetFindingsStatisticsRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.GetFindingsStatisticsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFindingsStatistics(request))
  def inviteMembers(request: InviteMembersRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.InviteMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.inviteMembers(request))
  def acceptAdministratorInvitation(
      request: AcceptAdministratorInvitationRequest
  ): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.AcceptAdministratorInvitationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acceptAdministratorInvitation(request))
  def archiveFindings(request: ArchiveFindingsRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.ArchiveFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.archiveFindings(request))
  def createThreatIntelSet(request: CreateThreatIntelSetRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.CreateThreatIntelSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createThreatIntelSet(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def getFindings(request: GetFindingsRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.GetFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFindings(request))
  def createMembers(request: CreateMembersRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.CreateMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMembers(request))
  def listThreatIntelSets(
      request: ListThreatIntelSetsRequest
  ): ZStream[zio.aws.guardduty.GuardDuty, AwsError, String] =
    ZStream.serviceWithStream(_.listThreatIntelSets(request))
  def listThreatIntelSetsPaginated(request: ListThreatIntelSetsRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.ListThreatIntelSetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listThreatIntelSetsPaginated(request))
  def listFilters(
      request: ListFiltersRequest
  ): ZStream[zio.aws.guardduty.GuardDuty, AwsError, FilterName] =
    ZStream.serviceWithStream(_.listFilters(request))
  def listFiltersPaginated(request: ListFiltersRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.ListFiltersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFiltersPaginated(request))
  def describeOrganizationConfiguration(
      request: DescribeOrganizationConfigurationRequest
  ): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.DescribeOrganizationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeOrganizationConfiguration(request))
  def getRemainingFreeTrialDays(request: GetRemainingFreeTrialDaysRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.GetRemainingFreeTrialDaysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRemainingFreeTrialDays(request))
  def listDetectors(
      request: ListDetectorsRequest
  ): ZStream[zio.aws.guardduty.GuardDuty, AwsError, DetectorId] =
    ZStream.serviceWithStream(_.listDetectors(request))
  def listDetectorsPaginated(request: ListDetectorsRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.ListDetectorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDetectorsPaginated(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listInvitations(request: ListInvitationsRequest): ZStream[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.Invitation.ReadOnly
  ] = ZStream.serviceWithStream(_.listInvitations(request))
  def listInvitationsPaginated(request: ListInvitationsRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.ListInvitationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInvitationsPaginated(request))
  def declineInvitations(request: DeclineInvitationsRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.DeclineInvitationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.declineInvitations(request))
  def getMalwareScanSettings(request: GetMalwareScanSettingsRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.GetMalwareScanSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMalwareScanSettings(request))
  def updateMemberDetectors(request: UpdateMemberDetectorsRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.UpdateMemberDetectorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMemberDetectors(request))
  def updateFilter(request: UpdateFilterRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.UpdateFilterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFilter(request))
  def enableOrganizationAdminAccount(
      request: EnableOrganizationAdminAccountRequest
  ): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.EnableOrganizationAdminAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableOrganizationAdminAccount(request))
  def startMonitoringMembers(request: StartMonitoringMembersRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.StartMonitoringMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startMonitoringMembers(request))
  def listIPSets(
      request: ListIpSetsRequest
  ): ZStream[zio.aws.guardduty.GuardDuty, AwsError, String] =
    ZStream.serviceWithStream(_.listIPSets(request))
  def listIPSetsPaginated(request: ListIpSetsRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.ListIpSetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listIPSetsPaginated(request))
  def deleteInvitations(request: DeleteInvitationsRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.DeleteInvitationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteInvitations(request))
  def createPublishingDestination(
      request: CreatePublishingDestinationRequest
  ): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.CreatePublishingDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPublishingDestination(request))
  def deleteIPSet(request: DeleteIpSetRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.DeleteIpSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteIPSet(request))
  def getDetector(request: GetDetectorRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.GetDetectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDetector(request))
  def deleteMembers(request: DeleteMembersRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.DeleteMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMembers(request))
  def getThreatIntelSet(request: GetThreatIntelSetRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.GetThreatIntelSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getThreatIntelSet(request))
  def disassociateFromAdministratorAccount(
      request: DisassociateFromAdministratorAccountRequest
  ): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.DisassociateFromAdministratorAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateFromAdministratorAccount(request))
  def getUsageStatistics(request: GetUsageStatisticsRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.GetUsageStatisticsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUsageStatistics(request))
  def getMembers(request: GetMembersRequest): ZIO[
    zio.aws.guardduty.GuardDuty,
    AwsError,
    zio.aws.guardduty.model.GetMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMembers(request))
}
