package zio.aws.guardduty
import zio.aws.guardduty.model.StopMonitoringMembersResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.guardduty.model.primitives.{DetectorId, FilterName, FindingId}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.guardduty.model.{
  InviteMembersRequest,
  UpdateFilterRequest,
  EnableOrganizationAdminAccountRequest,
  DisableOrganizationAdminAccountRequest,
  GetIpSetRequest,
  GetMalwareScanSettingsRequest,
  CreateThreatIntelSetRequest,
  DeleteInvitationsRequest,
  UpdatePublishingDestinationRequest,
  UpdateIpSetRequest,
  GetRemainingFreeTrialDaysRequest,
  GetMemberDetectorsRequest,
  DeleteThreatIntelSetRequest,
  CreateSampleFindingsRequest,
  ArchiveFindingsRequest,
  GetFilterRequest,
  GetMembersRequest,
  UpdateMalwareScanSettingsRequest,
  ListMembersRequest,
  DescribeMalwareScansRequest,
  ListDetectorsRequest,
  ListTagsForResourceRequest,
  GetFindingsRequest,
  DeleteIpSetRequest,
  GetThreatIntelSetRequest,
  StopMonitoringMembersRequest,
  CreatePublishingDestinationRequest,
  CreateMembersRequest,
  GetAdministratorAccountRequest,
  CreateFilterRequest,
  DeclineInvitationsRequest,
  ListOrganizationAdminAccountsRequest,
  ListFindingsRequest,
  UpdateOrganizationConfigurationRequest,
  ListFiltersRequest,
  ListInvitationsRequest,
  UpdateFindingsFeedbackRequest,
  UpdateMemberDetectorsRequest,
  StartMonitoringMembersRequest,
  DescribePublishingDestinationRequest,
  UpdateDetectorRequest,
  ListThreatIntelSetsRequest,
  UntagResourceRequest,
  ListPublishingDestinationsRequest,
  DeleteFilterRequest,
  UpdateThreatIntelSetRequest,
  AcceptAdministratorInvitationRequest,
  GetUsageStatisticsRequest,
  DeletePublishingDestinationRequest,
  GetDetectorRequest,
  DeleteMembersRequest,
  UnarchiveFindingsRequest,
  DescribeOrganizationConfigurationRequest,
  GetInvitationsCountRequest,
  DeleteDetectorRequest,
  GetFindingsStatisticsRequest,
  DisassociateFromAdministratorAccountRequest,
  TagResourceRequest,
  DisassociateMembersRequest,
  ListIpSetsRequest,
  CreateDetectorRequest,
  CreateIpSetRequest
}
import zio.stream.ZStream
import software.amazon.awssdk.services.guardduty.GuardDutyAsyncClient
object GuardDutyMock extends Mock[GuardDuty] {
  object GetAdministratorAccount
      extends Effect[
        GetAdministratorAccountRequest,
        AwsError,
        zio.aws.guardduty.model.GetAdministratorAccountResponse.ReadOnly
      ]
  object UpdateMalwareScanSettings
      extends Effect[
        UpdateMalwareScanSettingsRequest,
        AwsError,
        zio.aws.guardduty.model.UpdateMalwareScanSettingsResponse.ReadOnly
      ]
  object DeletePublishingDestination
      extends Effect[
        DeletePublishingDestinationRequest,
        AwsError,
        zio.aws.guardduty.model.DeletePublishingDestinationResponse.ReadOnly
      ]
  object DescribeMalwareScans
      extends Stream[
        DescribeMalwareScansRequest,
        AwsError,
        zio.aws.guardduty.model.Scan.ReadOnly
      ]
  object DescribeMalwareScansPaginated
      extends Effect[
        DescribeMalwareScansRequest,
        AwsError,
        zio.aws.guardduty.model.DescribeMalwareScansResponse.ReadOnly
      ]
  object ListFindings extends Stream[ListFindingsRequest, AwsError, FindingId]
  object ListFindingsPaginated
      extends Effect[
        ListFindingsRequest,
        AwsError,
        zio.aws.guardduty.model.ListFindingsResponse.ReadOnly
      ]
  object UpdateFindingsFeedback
      extends Effect[
        UpdateFindingsFeedbackRequest,
        AwsError,
        zio.aws.guardduty.model.UpdateFindingsFeedbackResponse.ReadOnly
      ]
  object DisableOrganizationAdminAccount
      extends Effect[
        DisableOrganizationAdminAccountRequest,
        AwsError,
        zio.aws.guardduty.model.DisableOrganizationAdminAccountResponse.ReadOnly
      ]
  object DeleteDetector
      extends Effect[
        DeleteDetectorRequest,
        AwsError,
        zio.aws.guardduty.model.DeleteDetectorResponse.ReadOnly
      ]
  object UpdatePublishingDestination
      extends Effect[
        UpdatePublishingDestinationRequest,
        AwsError,
        zio.aws.guardduty.model.UpdatePublishingDestinationResponse.ReadOnly
      ]
  object CreateSampleFindings
      extends Effect[
        CreateSampleFindingsRequest,
        AwsError,
        zio.aws.guardduty.model.CreateSampleFindingsResponse.ReadOnly
      ]
  object UnarchiveFindings
      extends Effect[
        UnarchiveFindingsRequest,
        AwsError,
        zio.aws.guardduty.model.UnarchiveFindingsResponse.ReadOnly
      ]
  object ListOrganizationAdminAccounts
      extends Stream[
        ListOrganizationAdminAccountsRequest,
        AwsError,
        zio.aws.guardduty.model.AdminAccount.ReadOnly
      ]
  object ListOrganizationAdminAccountsPaginated
      extends Effect[
        ListOrganizationAdminAccountsRequest,
        AwsError,
        zio.aws.guardduty.model.ListOrganizationAdminAccountsResponse.ReadOnly
      ]
  object UpdateOrganizationConfiguration
      extends Effect[
        UpdateOrganizationConfigurationRequest,
        AwsError,
        zio.aws.guardduty.model.UpdateOrganizationConfigurationResponse.ReadOnly
      ]
  object CreateDetector
      extends Effect[
        CreateDetectorRequest,
        AwsError,
        zio.aws.guardduty.model.CreateDetectorResponse.ReadOnly
      ]
  object GetIPSet
      extends Effect[
        GetIpSetRequest,
        AwsError,
        zio.aws.guardduty.model.GetIpSetResponse.ReadOnly
      ]
  object ListPublishingDestinations
      extends Stream[
        ListPublishingDestinationsRequest,
        AwsError,
        zio.aws.guardduty.model.Destination.ReadOnly
      ]
  object ListPublishingDestinationsPaginated
      extends Effect[
        ListPublishingDestinationsRequest,
        AwsError,
        zio.aws.guardduty.model.ListPublishingDestinationsResponse.ReadOnly
      ]
  object DeleteFilter
      extends Effect[
        DeleteFilterRequest,
        AwsError,
        zio.aws.guardduty.model.DeleteFilterResponse.ReadOnly
      ]
  object GetFilter
      extends Effect[
        GetFilterRequest,
        AwsError,
        zio.aws.guardduty.model.GetFilterResponse.ReadOnly
      ]
  object DescribePublishingDestination
      extends Effect[
        DescribePublishingDestinationRequest,
        AwsError,
        zio.aws.guardduty.model.DescribePublishingDestinationResponse.ReadOnly
      ]
  object DeleteThreatIntelSet
      extends Effect[
        DeleteThreatIntelSetRequest,
        AwsError,
        zio.aws.guardduty.model.DeleteThreatIntelSetResponse.ReadOnly
      ]
  object GetInvitationsCount
      extends Effect[
        GetInvitationsCountRequest,
        AwsError,
        zio.aws.guardduty.model.GetInvitationsCountResponse.ReadOnly
      ]
  object UpdateDetector
      extends Effect[
        UpdateDetectorRequest,
        AwsError,
        zio.aws.guardduty.model.UpdateDetectorResponse.ReadOnly
      ]
  object CreateIPSet
      extends Effect[
        CreateIpSetRequest,
        AwsError,
        zio.aws.guardduty.model.CreateIpSetResponse.ReadOnly
      ]
  object CreateFilter
      extends Effect[
        CreateFilterRequest,
        AwsError,
        zio.aws.guardduty.model.CreateFilterResponse.ReadOnly
      ]
  object DisassociateMembers
      extends Effect[
        DisassociateMembersRequest,
        AwsError,
        zio.aws.guardduty.model.DisassociateMembersResponse.ReadOnly
      ]
  object GetMemberDetectors
      extends Effect[
        GetMemberDetectorsRequest,
        AwsError,
        zio.aws.guardduty.model.GetMemberDetectorsResponse.ReadOnly
      ]
  object UpdateIPSet
      extends Effect[
        UpdateIpSetRequest,
        AwsError,
        zio.aws.guardduty.model.UpdateIpSetResponse.ReadOnly
      ]
  object ListMembers
      extends Stream[
        ListMembersRequest,
        AwsError,
        zio.aws.guardduty.model.Member.ReadOnly
      ]
  object ListMembersPaginated
      extends Effect[
        ListMembersRequest,
        AwsError,
        zio.aws.guardduty.model.ListMembersResponse.ReadOnly
      ]
  object UpdateThreatIntelSet
      extends Effect[
        UpdateThreatIntelSetRequest,
        AwsError,
        zio.aws.guardduty.model.UpdateThreatIntelSetResponse.ReadOnly
      ]
  object StopMonitoringMembers
      extends Effect[StopMonitoringMembersRequest, AwsError, ReadOnly]
  object GetFindingsStatistics
      extends Effect[
        GetFindingsStatisticsRequest,
        AwsError,
        zio.aws.guardduty.model.GetFindingsStatisticsResponse.ReadOnly
      ]
  object InviteMembers
      extends Effect[
        InviteMembersRequest,
        AwsError,
        zio.aws.guardduty.model.InviteMembersResponse.ReadOnly
      ]
  object AcceptAdministratorInvitation
      extends Effect[
        AcceptAdministratorInvitationRequest,
        AwsError,
        zio.aws.guardduty.model.AcceptAdministratorInvitationResponse.ReadOnly
      ]
  object ArchiveFindings
      extends Effect[
        ArchiveFindingsRequest,
        AwsError,
        zio.aws.guardduty.model.ArchiveFindingsResponse.ReadOnly
      ]
  object CreateThreatIntelSet
      extends Effect[
        CreateThreatIntelSetRequest,
        AwsError,
        zio.aws.guardduty.model.CreateThreatIntelSetResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.guardduty.model.UntagResourceResponse.ReadOnly
      ]
  object GetFindings
      extends Effect[
        GetFindingsRequest,
        AwsError,
        zio.aws.guardduty.model.GetFindingsResponse.ReadOnly
      ]
  object CreateMembers
      extends Effect[
        CreateMembersRequest,
        AwsError,
        zio.aws.guardduty.model.CreateMembersResponse.ReadOnly
      ]
  object ListThreatIntelSets
      extends Stream[ListThreatIntelSetsRequest, AwsError, String]
  object ListThreatIntelSetsPaginated
      extends Effect[
        ListThreatIntelSetsRequest,
        AwsError,
        zio.aws.guardduty.model.ListThreatIntelSetsResponse.ReadOnly
      ]
  object ListFilters extends Stream[ListFiltersRequest, AwsError, FilterName]
  object ListFiltersPaginated
      extends Effect[
        ListFiltersRequest,
        AwsError,
        zio.aws.guardduty.model.ListFiltersResponse.ReadOnly
      ]
  object DescribeOrganizationConfiguration
      extends Effect[
        DescribeOrganizationConfigurationRequest,
        AwsError,
        zio.aws.guardduty.model.DescribeOrganizationConfigurationResponse.ReadOnly
      ]
  object GetRemainingFreeTrialDays
      extends Effect[
        GetRemainingFreeTrialDaysRequest,
        AwsError,
        zio.aws.guardduty.model.GetRemainingFreeTrialDaysResponse.ReadOnly
      ]
  object ListDetectors
      extends Stream[ListDetectorsRequest, AwsError, DetectorId]
  object ListDetectorsPaginated
      extends Effect[
        ListDetectorsRequest,
        AwsError,
        zio.aws.guardduty.model.ListDetectorsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.guardduty.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.guardduty.model.TagResourceResponse.ReadOnly
      ]
  object ListInvitations
      extends Stream[
        ListInvitationsRequest,
        AwsError,
        zio.aws.guardduty.model.Invitation.ReadOnly
      ]
  object ListInvitationsPaginated
      extends Effect[
        ListInvitationsRequest,
        AwsError,
        zio.aws.guardduty.model.ListInvitationsResponse.ReadOnly
      ]
  object DeclineInvitations
      extends Effect[
        DeclineInvitationsRequest,
        AwsError,
        zio.aws.guardduty.model.DeclineInvitationsResponse.ReadOnly
      ]
  object GetMalwareScanSettings
      extends Effect[
        GetMalwareScanSettingsRequest,
        AwsError,
        zio.aws.guardduty.model.GetMalwareScanSettingsResponse.ReadOnly
      ]
  object UpdateMemberDetectors
      extends Effect[
        UpdateMemberDetectorsRequest,
        AwsError,
        zio.aws.guardduty.model.UpdateMemberDetectorsResponse.ReadOnly
      ]
  object UpdateFilter
      extends Effect[
        UpdateFilterRequest,
        AwsError,
        zio.aws.guardduty.model.UpdateFilterResponse.ReadOnly
      ]
  object EnableOrganizationAdminAccount
      extends Effect[
        EnableOrganizationAdminAccountRequest,
        AwsError,
        zio.aws.guardduty.model.EnableOrganizationAdminAccountResponse.ReadOnly
      ]
  object StartMonitoringMembers
      extends Effect[
        StartMonitoringMembersRequest,
        AwsError,
        zio.aws.guardduty.model.StartMonitoringMembersResponse.ReadOnly
      ]
  object ListIPSets extends Stream[ListIpSetsRequest, AwsError, String]
  object ListIPSetsPaginated
      extends Effect[
        ListIpSetsRequest,
        AwsError,
        zio.aws.guardduty.model.ListIpSetsResponse.ReadOnly
      ]
  object DeleteInvitations
      extends Effect[
        DeleteInvitationsRequest,
        AwsError,
        zio.aws.guardduty.model.DeleteInvitationsResponse.ReadOnly
      ]
  object CreatePublishingDestination
      extends Effect[
        CreatePublishingDestinationRequest,
        AwsError,
        zio.aws.guardduty.model.CreatePublishingDestinationResponse.ReadOnly
      ]
  object DeleteIPSet
      extends Effect[
        DeleteIpSetRequest,
        AwsError,
        zio.aws.guardduty.model.DeleteIpSetResponse.ReadOnly
      ]
  object GetDetector
      extends Effect[
        GetDetectorRequest,
        AwsError,
        zio.aws.guardduty.model.GetDetectorResponse.ReadOnly
      ]
  object DeleteMembers
      extends Effect[
        DeleteMembersRequest,
        AwsError,
        zio.aws.guardduty.model.DeleteMembersResponse.ReadOnly
      ]
  object GetThreatIntelSet
      extends Effect[
        GetThreatIntelSetRequest,
        AwsError,
        zio.aws.guardduty.model.GetThreatIntelSetResponse.ReadOnly
      ]
  object DisassociateFromAdministratorAccount
      extends Effect[
        DisassociateFromAdministratorAccountRequest,
        AwsError,
        zio.aws.guardduty.model.DisassociateFromAdministratorAccountResponse.ReadOnly
      ]
  object GetUsageStatistics
      extends Effect[
        GetUsageStatisticsRequest,
        AwsError,
        zio.aws.guardduty.model.GetUsageStatisticsResponse.ReadOnly
      ]
  object GetMembers
      extends Effect[
        GetMembersRequest,
        AwsError,
        zio.aws.guardduty.model.GetMembersResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, GuardDuty] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, GuardDuty] { rts =>
        zio.ZIO.succeed {
          new GuardDuty {
            val api: GuardDutyAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): GuardDuty = this
            def getAdministratorAccount(
                request: GetAdministratorAccountRequest
            ): IO[
              AwsError,
              zio.aws.guardduty.model.GetAdministratorAccountResponse.ReadOnly
            ] = proxy(GetAdministratorAccount, request)
            def updateMalwareScanSettings(
                request: UpdateMalwareScanSettingsRequest
            ): IO[
              AwsError,
              zio.aws.guardduty.model.UpdateMalwareScanSettingsResponse.ReadOnly
            ] = proxy(UpdateMalwareScanSettings, request)
            def deletePublishingDestination(
                request: DeletePublishingDestinationRequest
            ): IO[
              AwsError,
              zio.aws.guardduty.model.DeletePublishingDestinationResponse.ReadOnly
            ] = proxy(DeletePublishingDestination, request)
            def describeMalwareScans(
                request: DescribeMalwareScansRequest
            ): ZStream[Any, AwsError, zio.aws.guardduty.model.Scan.ReadOnly] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(DescribeMalwareScans, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def describeMalwareScansPaginated(
                request: DescribeMalwareScansRequest
            ): IO[
              AwsError,
              zio.aws.guardduty.model.DescribeMalwareScansResponse.ReadOnly
            ] = proxy(DescribeMalwareScansPaginated, request)
            def listFindings(
                request: ListFindingsRequest
            ): ZStream[Any, AwsError, FindingId] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListFindings, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listFindingsPaginated(request: ListFindingsRequest): IO[
              AwsError,
              zio.aws.guardduty.model.ListFindingsResponse.ReadOnly
            ] = proxy(ListFindingsPaginated, request)
            def updateFindingsFeedback(
                request: UpdateFindingsFeedbackRequest
            ): IO[
              AwsError,
              zio.aws.guardduty.model.UpdateFindingsFeedbackResponse.ReadOnly
            ] = proxy(UpdateFindingsFeedback, request)
            def disableOrganizationAdminAccount(
                request: DisableOrganizationAdminAccountRequest
            ): IO[
              AwsError,
              zio.aws.guardduty.model.DisableOrganizationAdminAccountResponse.ReadOnly
            ] = proxy(DisableOrganizationAdminAccount, request)
            def deleteDetector(request: DeleteDetectorRequest): IO[
              AwsError,
              zio.aws.guardduty.model.DeleteDetectorResponse.ReadOnly
            ] = proxy(DeleteDetector, request)
            def updatePublishingDestination(
                request: UpdatePublishingDestinationRequest
            ): IO[
              AwsError,
              zio.aws.guardduty.model.UpdatePublishingDestinationResponse.ReadOnly
            ] = proxy(UpdatePublishingDestination, request)
            def createSampleFindings(request: CreateSampleFindingsRequest): IO[
              AwsError,
              zio.aws.guardduty.model.CreateSampleFindingsResponse.ReadOnly
            ] = proxy(CreateSampleFindings, request)
            def unarchiveFindings(request: UnarchiveFindingsRequest): IO[
              AwsError,
              zio.aws.guardduty.model.UnarchiveFindingsResponse.ReadOnly
            ] = proxy(UnarchiveFindings, request)
            def listOrganizationAdminAccounts(
                request: ListOrganizationAdminAccountsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.guardduty.model.AdminAccount.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListOrganizationAdminAccounts, request)
                }
                .getOrThrowFiberFailure()
            }
            def listOrganizationAdminAccountsPaginated(
                request: ListOrganizationAdminAccountsRequest
            ): IO[
              AwsError,
              zio.aws.guardduty.model.ListOrganizationAdminAccountsResponse.ReadOnly
            ] = proxy(ListOrganizationAdminAccountsPaginated, request)
            def updateOrganizationConfiguration(
                request: UpdateOrganizationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.guardduty.model.UpdateOrganizationConfigurationResponse.ReadOnly
            ] = proxy(UpdateOrganizationConfiguration, request)
            def createDetector(request: CreateDetectorRequest): IO[
              AwsError,
              zio.aws.guardduty.model.CreateDetectorResponse.ReadOnly
            ] = proxy(CreateDetector, request)
            def getIPSet(
                request: GetIpSetRequest
            ): IO[AwsError, zio.aws.guardduty.model.GetIpSetResponse.ReadOnly] =
              proxy(GetIPSet, request)
            def listPublishingDestinations(
                request: ListPublishingDestinationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.guardduty.model.Destination.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPublishingDestinations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPublishingDestinationsPaginated(
                request: ListPublishingDestinationsRequest
            ): IO[
              AwsError,
              zio.aws.guardduty.model.ListPublishingDestinationsResponse.ReadOnly
            ] = proxy(ListPublishingDestinationsPaginated, request)
            def deleteFilter(request: DeleteFilterRequest): IO[
              AwsError,
              zio.aws.guardduty.model.DeleteFilterResponse.ReadOnly
            ] = proxy(DeleteFilter, request)
            def getFilter(request: GetFilterRequest): IO[
              AwsError,
              zio.aws.guardduty.model.GetFilterResponse.ReadOnly
            ] = proxy(GetFilter, request)
            def describePublishingDestination(
                request: DescribePublishingDestinationRequest
            ): IO[
              AwsError,
              zio.aws.guardduty.model.DescribePublishingDestinationResponse.ReadOnly
            ] = proxy(DescribePublishingDestination, request)
            def deleteThreatIntelSet(request: DeleteThreatIntelSetRequest): IO[
              AwsError,
              zio.aws.guardduty.model.DeleteThreatIntelSetResponse.ReadOnly
            ] = proxy(DeleteThreatIntelSet, request)
            def getInvitationsCount(request: GetInvitationsCountRequest): IO[
              AwsError,
              zio.aws.guardduty.model.GetInvitationsCountResponse.ReadOnly
            ] = proxy(GetInvitationsCount, request)
            def updateDetector(request: UpdateDetectorRequest): IO[
              AwsError,
              zio.aws.guardduty.model.UpdateDetectorResponse.ReadOnly
            ] = proxy(UpdateDetector, request)
            def createIPSet(request: CreateIpSetRequest): IO[
              AwsError,
              zio.aws.guardduty.model.CreateIpSetResponse.ReadOnly
            ] = proxy(CreateIPSet, request)
            def createFilter(request: CreateFilterRequest): IO[
              AwsError,
              zio.aws.guardduty.model.CreateFilterResponse.ReadOnly
            ] = proxy(CreateFilter, request)
            def disassociateMembers(request: DisassociateMembersRequest): IO[
              AwsError,
              zio.aws.guardduty.model.DisassociateMembersResponse.ReadOnly
            ] = proxy(DisassociateMembers, request)
            def getMemberDetectors(request: GetMemberDetectorsRequest): IO[
              AwsError,
              zio.aws.guardduty.model.GetMemberDetectorsResponse.ReadOnly
            ] = proxy(GetMemberDetectors, request)
            def updateIPSet(request: UpdateIpSetRequest): IO[
              AwsError,
              zio.aws.guardduty.model.UpdateIpSetResponse.ReadOnly
            ] = proxy(UpdateIPSet, request)
            def listMembers(
                request: ListMembersRequest
            ): ZStream[Any, AwsError, zio.aws.guardduty.model.Member.ReadOnly] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListMembers, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listMembersPaginated(request: ListMembersRequest): IO[
              AwsError,
              zio.aws.guardduty.model.ListMembersResponse.ReadOnly
            ] = proxy(ListMembersPaginated, request)
            def updateThreatIntelSet(request: UpdateThreatIntelSetRequest): IO[
              AwsError,
              zio.aws.guardduty.model.UpdateThreatIntelSetResponse.ReadOnly
            ] = proxy(UpdateThreatIntelSet, request)
            def stopMonitoringMembers(
                request: StopMonitoringMembersRequest
            ): IO[AwsError, ReadOnly] = proxy(StopMonitoringMembers, request)
            def getFindingsStatistics(
                request: GetFindingsStatisticsRequest
            ): IO[
              AwsError,
              zio.aws.guardduty.model.GetFindingsStatisticsResponse.ReadOnly
            ] = proxy(GetFindingsStatistics, request)
            def inviteMembers(request: InviteMembersRequest): IO[
              AwsError,
              zio.aws.guardduty.model.InviteMembersResponse.ReadOnly
            ] = proxy(InviteMembers, request)
            def acceptAdministratorInvitation(
                request: AcceptAdministratorInvitationRequest
            ): IO[
              AwsError,
              zio.aws.guardduty.model.AcceptAdministratorInvitationResponse.ReadOnly
            ] = proxy(AcceptAdministratorInvitation, request)
            def archiveFindings(request: ArchiveFindingsRequest): IO[
              AwsError,
              zio.aws.guardduty.model.ArchiveFindingsResponse.ReadOnly
            ] = proxy(ArchiveFindings, request)
            def createThreatIntelSet(request: CreateThreatIntelSetRequest): IO[
              AwsError,
              zio.aws.guardduty.model.CreateThreatIntelSetResponse.ReadOnly
            ] = proxy(CreateThreatIntelSet, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.guardduty.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def getFindings(request: GetFindingsRequest): IO[
              AwsError,
              zio.aws.guardduty.model.GetFindingsResponse.ReadOnly
            ] = proxy(GetFindings, request)
            def createMembers(request: CreateMembersRequest): IO[
              AwsError,
              zio.aws.guardduty.model.CreateMembersResponse.ReadOnly
            ] = proxy(CreateMembers, request)
            def listThreatIntelSets(
                request: ListThreatIntelSetsRequest
            ): ZStream[Any, AwsError, String] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListThreatIntelSets, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listThreatIntelSetsPaginated(
                request: ListThreatIntelSetsRequest
            ): IO[
              AwsError,
              zio.aws.guardduty.model.ListThreatIntelSetsResponse.ReadOnly
            ] = proxy(ListThreatIntelSetsPaginated, request)
            def listFilters(
                request: ListFiltersRequest
            ): ZStream[Any, AwsError, FilterName] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListFilters, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listFiltersPaginated(request: ListFiltersRequest): IO[
              AwsError,
              zio.aws.guardduty.model.ListFiltersResponse.ReadOnly
            ] = proxy(ListFiltersPaginated, request)
            def describeOrganizationConfiguration(
                request: DescribeOrganizationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.guardduty.model.DescribeOrganizationConfigurationResponse.ReadOnly
            ] = proxy(DescribeOrganizationConfiguration, request)
            def getRemainingFreeTrialDays(
                request: GetRemainingFreeTrialDaysRequest
            ): IO[
              AwsError,
              zio.aws.guardduty.model.GetRemainingFreeTrialDaysResponse.ReadOnly
            ] = proxy(GetRemainingFreeTrialDays, request)
            def listDetectors(
                request: ListDetectorsRequest
            ): ZStream[Any, AwsError, DetectorId] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListDetectors, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listDetectorsPaginated(request: ListDetectorsRequest): IO[
              AwsError,
              zio.aws.guardduty.model.ListDetectorsResponse.ReadOnly
            ] = proxy(ListDetectorsPaginated, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.guardduty.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.guardduty.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def listInvitations(request: ListInvitationsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.guardduty.model.Invitation.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListInvitations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listInvitationsPaginated(request: ListInvitationsRequest): IO[
              AwsError,
              zio.aws.guardduty.model.ListInvitationsResponse.ReadOnly
            ] = proxy(ListInvitationsPaginated, request)
            def declineInvitations(request: DeclineInvitationsRequest): IO[
              AwsError,
              zio.aws.guardduty.model.DeclineInvitationsResponse.ReadOnly
            ] = proxy(DeclineInvitations, request)
            def getMalwareScanSettings(
                request: GetMalwareScanSettingsRequest
            ): IO[
              AwsError,
              zio.aws.guardduty.model.GetMalwareScanSettingsResponse.ReadOnly
            ] = proxy(GetMalwareScanSettings, request)
            def updateMemberDetectors(
                request: UpdateMemberDetectorsRequest
            ): IO[
              AwsError,
              zio.aws.guardduty.model.UpdateMemberDetectorsResponse.ReadOnly
            ] = proxy(UpdateMemberDetectors, request)
            def updateFilter(request: UpdateFilterRequest): IO[
              AwsError,
              zio.aws.guardduty.model.UpdateFilterResponse.ReadOnly
            ] = proxy(UpdateFilter, request)
            def enableOrganizationAdminAccount(
                request: EnableOrganizationAdminAccountRequest
            ): IO[
              AwsError,
              zio.aws.guardduty.model.EnableOrganizationAdminAccountResponse.ReadOnly
            ] = proxy(EnableOrganizationAdminAccount, request)
            def startMonitoringMembers(
                request: StartMonitoringMembersRequest
            ): IO[
              AwsError,
              zio.aws.guardduty.model.StartMonitoringMembersResponse.ReadOnly
            ] = proxy(StartMonitoringMembers, request)
            def listIPSets(
                request: ListIpSetsRequest
            ): ZStream[Any, AwsError, String] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListIPSets, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listIPSetsPaginated(request: ListIpSetsRequest): IO[
              AwsError,
              zio.aws.guardduty.model.ListIpSetsResponse.ReadOnly
            ] = proxy(ListIPSetsPaginated, request)
            def deleteInvitations(request: DeleteInvitationsRequest): IO[
              AwsError,
              zio.aws.guardduty.model.DeleteInvitationsResponse.ReadOnly
            ] = proxy(DeleteInvitations, request)
            def createPublishingDestination(
                request: CreatePublishingDestinationRequest
            ): IO[
              AwsError,
              zio.aws.guardduty.model.CreatePublishingDestinationResponse.ReadOnly
            ] = proxy(CreatePublishingDestination, request)
            def deleteIPSet(request: DeleteIpSetRequest): IO[
              AwsError,
              zio.aws.guardduty.model.DeleteIpSetResponse.ReadOnly
            ] = proxy(DeleteIPSet, request)
            def getDetector(request: GetDetectorRequest): IO[
              AwsError,
              zio.aws.guardduty.model.GetDetectorResponse.ReadOnly
            ] = proxy(GetDetector, request)
            def deleteMembers(request: DeleteMembersRequest): IO[
              AwsError,
              zio.aws.guardduty.model.DeleteMembersResponse.ReadOnly
            ] = proxy(DeleteMembers, request)
            def getThreatIntelSet(request: GetThreatIntelSetRequest): IO[
              AwsError,
              zio.aws.guardduty.model.GetThreatIntelSetResponse.ReadOnly
            ] = proxy(GetThreatIntelSet, request)
            def disassociateFromAdministratorAccount(
                request: DisassociateFromAdministratorAccountRequest
            ): IO[
              AwsError,
              zio.aws.guardduty.model.DisassociateFromAdministratorAccountResponse.ReadOnly
            ] = proxy(DisassociateFromAdministratorAccount, request)
            def getUsageStatistics(request: GetUsageStatisticsRequest): IO[
              AwsError,
              zio.aws.guardduty.model.GetUsageStatisticsResponse.ReadOnly
            ] = proxy(GetUsageStatistics, request)
            def getMembers(request: GetMembersRequest): IO[
              AwsError,
              zio.aws.guardduty.model.GetMembersResponse.ReadOnly
            ] = proxy(GetMembers, request)
          }
        }
      }
    }
  }
}
