package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.DetectorId
import scala.jdk.CollectionConverters.*
final case class AcceptAdministratorInvitationRequest(
    detectorId: DetectorId,
    administratorId: String,
    invitationId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.AcceptAdministratorInvitationRequest = {
    import AcceptAdministratorInvitationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.AcceptAdministratorInvitationRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .administratorId(administratorId: java.lang.String)
      .invitationId(invitationId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.AcceptAdministratorInvitationRequest.ReadOnly =
    zio.aws.guardduty.model.AcceptAdministratorInvitationRequest
      .wrap(buildAwsValue())
}
object AcceptAdministratorInvitationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.AcceptAdministratorInvitationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.guardduty.model.AcceptAdministratorInvitationRequest =
      zio.aws.guardduty.model.AcceptAdministratorInvitationRequest(
        detectorId,
        administratorId,
        invitationId
      )
    def detectorId: DetectorId
    def administratorId: String
    def invitationId: String
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getAdministratorId: ZIO[Any, Nothing, String] =
      ZIO.succeed(administratorId)
    def getInvitationId: ZIO[Any, Nothing, String] = ZIO.succeed(invitationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.AcceptAdministratorInvitationRequest
  ) extends zio.aws.guardduty.model.AcceptAdministratorInvitationRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val administratorId: String = impl.administratorId(): String
    override val invitationId: String = impl.invitationId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.AcceptAdministratorInvitationRequest
  ): zio.aws.guardduty.model.AcceptAdministratorInvitationRequest.ReadOnly =
    new Wrapper(impl)
}
