package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AccessControlList(
    allowsPublicReadAccess: Optional[Boolean] = Optional.Absent,
    allowsPublicWriteAccess: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.AccessControlList = {
    import AccessControlList.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.AccessControlList
      .builder()
      .optionallyWith(
        allowsPublicReadAccess.map(value => value: java.lang.Boolean)
      )(_.allowsPublicReadAccess)
      .optionallyWith(
        allowsPublicWriteAccess.map(value => value: java.lang.Boolean)
      )(_.allowsPublicWriteAccess)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.AccessControlList.ReadOnly =
    zio.aws.guardduty.model.AccessControlList.wrap(buildAwsValue())
}
object AccessControlList {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.AccessControlList
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.AccessControlList =
      zio.aws.guardduty.model.AccessControlList(
        allowsPublicReadAccess.map(value => value),
        allowsPublicWriteAccess.map(value => value)
      )
    def allowsPublicReadAccess: Optional[Boolean]
    def allowsPublicWriteAccess: Optional[Boolean]
    def getAllowsPublicReadAccess: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("allowsPublicReadAccess", allowsPublicReadAccess)
    def getAllowsPublicWriteAccess: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("allowsPublicWriteAccess", allowsPublicWriteAccess)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.AccessControlList
  ) extends zio.aws.guardduty.model.AccessControlList.ReadOnly {
    override val allowsPublicReadAccess: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowsPublicReadAccess())
        .map(value => value: Boolean)
    override val allowsPublicWriteAccess: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowsPublicWriteAccess())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.AccessControlList
  ): zio.aws.guardduty.model.AccessControlList.ReadOnly = new Wrapper(impl)
}
