package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AccessKeyDetails(
    accessKeyId: Optional[String] = Optional.Absent,
    principalId: Optional[String] = Optional.Absent,
    userName: Optional[String] = Optional.Absent,
    userType: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.AccessKeyDetails = {
    import AccessKeyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.AccessKeyDetails
      .builder()
      .optionallyWith(accessKeyId.map(value => value: java.lang.String))(
        _.accessKeyId
      )
      .optionallyWith(principalId.map(value => value: java.lang.String))(
        _.principalId
      )
      .optionallyWith(userName.map(value => value: java.lang.String))(
        _.userName
      )
      .optionallyWith(userType.map(value => value: java.lang.String))(
        _.userType
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.AccessKeyDetails.ReadOnly =
    zio.aws.guardduty.model.AccessKeyDetails.wrap(buildAwsValue())
}
object AccessKeyDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.AccessKeyDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.AccessKeyDetails =
      zio.aws.guardduty.model.AccessKeyDetails(
        accessKeyId.map(value => value),
        principalId.map(value => value),
        userName.map(value => value),
        userType.map(value => value)
      )
    def accessKeyId: Optional[String]
    def principalId: Optional[String]
    def userName: Optional[String]
    def userType: Optional[String]
    def getAccessKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accessKeyId", accessKeyId)
    def getPrincipalId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getUserName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userName", userName)
    def getUserType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userType", userType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.AccessKeyDetails
  ) extends zio.aws.guardduty.model.AccessKeyDetails.ReadOnly {
    override val accessKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.accessKeyId())
      .map(value => value: String)
    override val principalId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.principalId())
      .map(value => value: String)
    override val userName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => value: String)
    override val userType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.AccessKeyDetails
  ): zio.aws.guardduty.model.AccessKeyDetails.ReadOnly = new Wrapper(impl)
}
