package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.{Email, AccountId}
import scala.jdk.CollectionConverters.*
final case class AccountDetail(accountId: AccountId, email: Email) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.AccountDetail = {
    import AccountDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.AccountDetail
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .email(Email.unwrap(email): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.AccountDetail.ReadOnly =
    zio.aws.guardduty.model.AccountDetail.wrap(buildAwsValue())
}
object AccountDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.AccountDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.AccountDetail =
      zio.aws.guardduty.model.AccountDetail(accountId, email)
    def accountId: AccountId
    def email: Email
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getEmail: ZIO[Any, Nothing, Email] = ZIO.succeed(email)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.AccountDetail
  ) extends zio.aws.guardduty.model.AccountDetail.ReadOnly {
    override val accountId: AccountId =
      zio.aws.guardduty.model.primitives.AccountId(impl.accountId())
    override val email: Email =
      zio.aws.guardduty.model.primitives.Email(impl.email())
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.AccountDetail
  ): zio.aws.guardduty.model.AccountDetail.ReadOnly = new Wrapper(impl)
}
