package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AccountFreeTrialInfo(
    accountId: Optional[String] = Optional.Absent,
    dataSources: Optional[zio.aws.guardduty.model.DataSourcesFreeTrial] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.AccountFreeTrialInfo = {
    import AccountFreeTrialInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.AccountFreeTrialInfo
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(dataSources.map(value => value.buildAwsValue()))(
        _.dataSources
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.AccountFreeTrialInfo.ReadOnly =
    zio.aws.guardduty.model.AccountFreeTrialInfo.wrap(buildAwsValue())
}
object AccountFreeTrialInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.AccountFreeTrialInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.AccountFreeTrialInfo =
      zio.aws.guardduty.model.AccountFreeTrialInfo(
        accountId.map(value => value),
        dataSources.map(value => value.asEditable)
      )
    def accountId: Optional[String]
    def dataSources
        : Optional[zio.aws.guardduty.model.DataSourcesFreeTrial.ReadOnly]
    def getAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getDataSources: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.DataSourcesFreeTrial.ReadOnly
    ] = AwsError.unwrapOptionField("dataSources", dataSources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.AccountFreeTrialInfo
  ) extends zio.aws.guardduty.model.AccountFreeTrialInfo.ReadOnly {
    override val accountId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: String)
    override val dataSources
        : Optional[zio.aws.guardduty.model.DataSourcesFreeTrial.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSources())
        .map(value => zio.aws.guardduty.model.DataSourcesFreeTrial.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.AccountFreeTrialInfo
  ): zio.aws.guardduty.model.AccountFreeTrialInfo.ReadOnly = new Wrapper(impl)
}
