package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AccountLevelPermissions(
    blockPublicAccess: Optional[zio.aws.guardduty.model.BlockPublicAccess] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.AccountLevelPermissions = {
    import AccountLevelPermissions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.AccountLevelPermissions
      .builder()
      .optionallyWith(blockPublicAccess.map(value => value.buildAwsValue()))(
        _.blockPublicAccess
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.AccountLevelPermissions.ReadOnly =
    zio.aws.guardduty.model.AccountLevelPermissions.wrap(buildAwsValue())
}
object AccountLevelPermissions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.AccountLevelPermissions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.AccountLevelPermissions =
      zio.aws.guardduty.model.AccountLevelPermissions(
        blockPublicAccess.map(value => value.asEditable)
      )
    def blockPublicAccess
        : Optional[zio.aws.guardduty.model.BlockPublicAccess.ReadOnly]
    def getBlockPublicAccess: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.BlockPublicAccess.ReadOnly
    ] = AwsError.unwrapOptionField("blockPublicAccess", blockPublicAccess)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.AccountLevelPermissions
  ) extends zio.aws.guardduty.model.AccountLevelPermissions.ReadOnly {
    override val blockPublicAccess
        : Optional[zio.aws.guardduty.model.BlockPublicAccess.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockPublicAccess())
        .map(value => zio.aws.guardduty.model.BlockPublicAccess.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.AccountLevelPermissions
  ): zio.aws.guardduty.model.AccountLevelPermissions.ReadOnly = new Wrapper(
    impl
  )
}
