package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Action(
    actionType: Optional[String] = Optional.Absent,
    awsApiCallAction: Optional[zio.aws.guardduty.model.AwsApiCallAction] =
      Optional.Absent,
    dnsRequestAction: Optional[zio.aws.guardduty.model.DnsRequestAction] =
      Optional.Absent,
    networkConnectionAction: Optional[
      zio.aws.guardduty.model.NetworkConnectionAction
    ] = Optional.Absent,
    portProbeAction: Optional[zio.aws.guardduty.model.PortProbeAction] =
      Optional.Absent,
    kubernetesApiCallAction: Optional[
      zio.aws.guardduty.model.KubernetesApiCallAction
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.Action = {
    import Action.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.Action
      .builder()
      .optionallyWith(actionType.map(value => value: java.lang.String))(
        _.actionType
      )
      .optionallyWith(awsApiCallAction.map(value => value.buildAwsValue()))(
        _.awsApiCallAction
      )
      .optionallyWith(dnsRequestAction.map(value => value.buildAwsValue()))(
        _.dnsRequestAction
      )
      .optionallyWith(
        networkConnectionAction.map(value => value.buildAwsValue())
      )(_.networkConnectionAction)
      .optionallyWith(portProbeAction.map(value => value.buildAwsValue()))(
        _.portProbeAction
      )
      .optionallyWith(
        kubernetesApiCallAction.map(value => value.buildAwsValue())
      )(_.kubernetesApiCallAction)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.Action.ReadOnly =
    zio.aws.guardduty.model.Action.wrap(buildAwsValue())
}
object Action {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.guardduty.model.Action] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.Action =
      zio.aws.guardduty.model.Action(
        actionType.map(value => value),
        awsApiCallAction.map(value => value.asEditable),
        dnsRequestAction.map(value => value.asEditable),
        networkConnectionAction.map(value => value.asEditable),
        portProbeAction.map(value => value.asEditable),
        kubernetesApiCallAction.map(value => value.asEditable)
      )
    def actionType: Optional[String]
    def awsApiCallAction
        : Optional[zio.aws.guardduty.model.AwsApiCallAction.ReadOnly]
    def dnsRequestAction
        : Optional[zio.aws.guardduty.model.DnsRequestAction.ReadOnly]
    def networkConnectionAction
        : Optional[zio.aws.guardduty.model.NetworkConnectionAction.ReadOnly]
    def portProbeAction
        : Optional[zio.aws.guardduty.model.PortProbeAction.ReadOnly]
    def kubernetesApiCallAction
        : Optional[zio.aws.guardduty.model.KubernetesApiCallAction.ReadOnly]
    def getActionType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("actionType", actionType)
    def getAwsApiCallAction: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.AwsApiCallAction.ReadOnly
    ] = AwsError.unwrapOptionField("awsApiCallAction", awsApiCallAction)
    def getDnsRequestAction: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.DnsRequestAction.ReadOnly
    ] = AwsError.unwrapOptionField("dnsRequestAction", dnsRequestAction)
    def getNetworkConnectionAction: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.NetworkConnectionAction.ReadOnly
    ] = AwsError.unwrapOptionField(
      "networkConnectionAction",
      networkConnectionAction
    )
    def getPortProbeAction
        : ZIO[Any, AwsError, zio.aws.guardduty.model.PortProbeAction.ReadOnly] =
      AwsError.unwrapOptionField("portProbeAction", portProbeAction)
    def getKubernetesApiCallAction: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.KubernetesApiCallAction.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kubernetesApiCallAction",
      kubernetesApiCallAction
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.Action
  ) extends zio.aws.guardduty.model.Action.ReadOnly {
    override val actionType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.actionType())
      .map(value => value: String)
    override val awsApiCallAction
        : Optional[zio.aws.guardduty.model.AwsApiCallAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsApiCallAction())
        .map(value => zio.aws.guardduty.model.AwsApiCallAction.wrap(value))
    override val dnsRequestAction
        : Optional[zio.aws.guardduty.model.DnsRequestAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsRequestAction())
        .map(value => zio.aws.guardduty.model.DnsRequestAction.wrap(value))
    override val networkConnectionAction
        : Optional[zio.aws.guardduty.model.NetworkConnectionAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkConnectionAction())
        .map(value =>
          zio.aws.guardduty.model.NetworkConnectionAction.wrap(value)
        )
    override val portProbeAction
        : Optional[zio.aws.guardduty.model.PortProbeAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portProbeAction())
        .map(value => zio.aws.guardduty.model.PortProbeAction.wrap(value))
    override val kubernetesApiCallAction
        : Optional[zio.aws.guardduty.model.KubernetesApiCallAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kubernetesApiCallAction())
        .map(value =>
          zio.aws.guardduty.model.KubernetesApiCallAction.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.Action
  ): zio.aws.guardduty.model.Action.ReadOnly = new Wrapper(impl)
}
