package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AdminAccount(
    adminAccountId: Optional[String] = Optional.Absent,
    adminStatus: Optional[zio.aws.guardduty.model.AdminStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.AdminAccount = {
    import AdminAccount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.AdminAccount
      .builder()
      .optionallyWith(adminAccountId.map(value => value: java.lang.String))(
        _.adminAccountId
      )
      .optionallyWith(adminStatus.map(value => value.unwrap))(_.adminStatus)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.AdminAccount.ReadOnly =
    zio.aws.guardduty.model.AdminAccount.wrap(buildAwsValue())
}
object AdminAccount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.AdminAccount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.AdminAccount =
      zio.aws.guardduty.model.AdminAccount(
        adminAccountId.map(value => value),
        adminStatus.map(value => value)
      )
    def adminAccountId: Optional[String]
    def adminStatus: Optional[zio.aws.guardduty.model.AdminStatus]
    def getAdminAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("adminAccountId", adminAccountId)
    def getAdminStatus
        : ZIO[Any, AwsError, zio.aws.guardduty.model.AdminStatus] =
      AwsError.unwrapOptionField("adminStatus", adminStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.AdminAccount
  ) extends zio.aws.guardduty.model.AdminAccount.ReadOnly {
    override val adminAccountId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.adminAccountId())
      .map(value => value: String)
    override val adminStatus: Optional[zio.aws.guardduty.model.AdminStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adminStatus())
        .map(value => zio.aws.guardduty.model.AdminStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.AdminAccount
  ): zio.aws.guardduty.model.AdminAccount.ReadOnly = new Wrapper(impl)
}
