package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class Administrator(
    accountId: Optional[AccountId] = Optional.Absent,
    invitationId: Optional[String] = Optional.Absent,
    relationshipStatus: Optional[String] = Optional.Absent,
    invitedAt: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.Administrator = {
    import Administrator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.Administrator
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(invitationId.map(value => value: java.lang.String))(
        _.invitationId
      )
      .optionallyWith(relationshipStatus.map(value => value: java.lang.String))(
        _.relationshipStatus
      )
      .optionallyWith(invitedAt.map(value => value: java.lang.String))(
        _.invitedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.Administrator.ReadOnly =
    zio.aws.guardduty.model.Administrator.wrap(buildAwsValue())
}
object Administrator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.Administrator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.Administrator =
      zio.aws.guardduty.model.Administrator(
        accountId.map(value => value),
        invitationId.map(value => value),
        relationshipStatus.map(value => value),
        invitedAt.map(value => value)
      )
    def accountId: Optional[AccountId]
    def invitationId: Optional[String]
    def relationshipStatus: Optional[String]
    def invitedAt: Optional[String]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getInvitationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("invitationId", invitationId)
    def getRelationshipStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("relationshipStatus", relationshipStatus)
    def getInvitedAt: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("invitedAt", invitedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.Administrator
  ) extends zio.aws.guardduty.model.Administrator.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.guardduty.model.primitives.AccountId(value))
    override val invitationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.invitationId())
      .map(value => value: String)
    override val relationshipStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.relationshipStatus())
      .map(value => value: String)
    override val invitedAt: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.invitedAt())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.Administrator
  ): zio.aws.guardduty.model.Administrator.ReadOnly = new Wrapper(impl)
}
