package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AwsApiCallAction(
    api: Optional[String] = Optional.Absent,
    callerType: Optional[String] = Optional.Absent,
    domainDetails: Optional[zio.aws.guardduty.model.DomainDetails] =
      Optional.Absent,
    errorCode: Optional[String] = Optional.Absent,
    userAgent: Optional[String] = Optional.Absent,
    remoteIpDetails: Optional[zio.aws.guardduty.model.RemoteIpDetails] =
      Optional.Absent,
    serviceName: Optional[String] = Optional.Absent,
    remoteAccountDetails: Optional[
      zio.aws.guardduty.model.RemoteAccountDetails
    ] = Optional.Absent,
    affectedResources: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.AwsApiCallAction = {
    import AwsApiCallAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.AwsApiCallAction
      .builder()
      .optionallyWith(api.map(value => value: java.lang.String))(_.api)
      .optionallyWith(callerType.map(value => value: java.lang.String))(
        _.callerType
      )
      .optionallyWith(domainDetails.map(value => value.buildAwsValue()))(
        _.domainDetails
      )
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(userAgent.map(value => value: java.lang.String))(
        _.userAgent
      )
      .optionallyWith(remoteIpDetails.map(value => value.buildAwsValue()))(
        _.remoteIpDetails
      )
      .optionallyWith(serviceName.map(value => value: java.lang.String))(
        _.serviceName
      )
      .optionallyWith(remoteAccountDetails.map(value => value.buildAwsValue()))(
        _.remoteAccountDetails
      )
      .optionallyWith(
        affectedResources.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.affectedResources)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.AwsApiCallAction.ReadOnly =
    zio.aws.guardduty.model.AwsApiCallAction.wrap(buildAwsValue())
}
object AwsApiCallAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.AwsApiCallAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.AwsApiCallAction =
      zio.aws.guardduty.model.AwsApiCallAction(
        api.map(value => value),
        callerType.map(value => value),
        domainDetails.map(value => value.asEditable),
        errorCode.map(value => value),
        userAgent.map(value => value),
        remoteIpDetails.map(value => value.asEditable),
        serviceName.map(value => value),
        remoteAccountDetails.map(value => value.asEditable),
        affectedResources.map(value => value)
      )
    def api: Optional[String]
    def callerType: Optional[String]
    def domainDetails: Optional[zio.aws.guardduty.model.DomainDetails.ReadOnly]
    def errorCode: Optional[String]
    def userAgent: Optional[String]
    def remoteIpDetails
        : Optional[zio.aws.guardduty.model.RemoteIpDetails.ReadOnly]
    def serviceName: Optional[String]
    def remoteAccountDetails
        : Optional[zio.aws.guardduty.model.RemoteAccountDetails.ReadOnly]
    def affectedResources: Optional[Map[String, String]]
    def getApi: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("api", api)
    def getCallerType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("callerType", callerType)
    def getDomainDetails
        : ZIO[Any, AwsError, zio.aws.guardduty.model.DomainDetails.ReadOnly] =
      AwsError.unwrapOptionField("domainDetails", domainDetails)
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getUserAgent: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userAgent", userAgent)
    def getRemoteIpDetails
        : ZIO[Any, AwsError, zio.aws.guardduty.model.RemoteIpDetails.ReadOnly] =
      AwsError.unwrapOptionField("remoteIpDetails", remoteIpDetails)
    def getServiceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getRemoteAccountDetails: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.RemoteAccountDetails.ReadOnly
    ] = AwsError.unwrapOptionField("remoteAccountDetails", remoteAccountDetails)
    def getAffectedResources: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("affectedResources", affectedResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.AwsApiCallAction
  ) extends zio.aws.guardduty.model.AwsApiCallAction.ReadOnly {
    override val api: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.api())
      .map(value => value: String)
    override val callerType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.callerType())
      .map(value => value: String)
    override val domainDetails
        : Optional[zio.aws.guardduty.model.DomainDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainDetails())
        .map(value => zio.aws.guardduty.model.DomainDetails.wrap(value))
    override val errorCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => value: String)
    override val userAgent: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userAgent())
      .map(value => value: String)
    override val remoteIpDetails
        : Optional[zio.aws.guardduty.model.RemoteIpDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remoteIpDetails())
        .map(value => zio.aws.guardduty.model.RemoteIpDetails.wrap(value))
    override val serviceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => value: String)
    override val remoteAccountDetails
        : Optional[zio.aws.guardduty.model.RemoteAccountDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remoteAccountDetails())
        .map(value => zio.aws.guardduty.model.RemoteAccountDetails.wrap(value))
    override val affectedResources: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.affectedResources())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.AwsApiCallAction
  ): zio.aws.guardduty.model.AwsApiCallAction.ReadOnly = new Wrapper(impl)
}
