package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BlockPublicAccess(
    ignorePublicAcls: Optional[Boolean] = Optional.Absent,
    restrictPublicBuckets: Optional[Boolean] = Optional.Absent,
    blockPublicAcls: Optional[Boolean] = Optional.Absent,
    blockPublicPolicy: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.BlockPublicAccess = {
    import BlockPublicAccess.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.BlockPublicAccess
      .builder()
      .optionallyWith(ignorePublicAcls.map(value => value: java.lang.Boolean))(
        _.ignorePublicAcls
      )
      .optionallyWith(
        restrictPublicBuckets.map(value => value: java.lang.Boolean)
      )(_.restrictPublicBuckets)
      .optionallyWith(blockPublicAcls.map(value => value: java.lang.Boolean))(
        _.blockPublicAcls
      )
      .optionallyWith(blockPublicPolicy.map(value => value: java.lang.Boolean))(
        _.blockPublicPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.BlockPublicAccess.ReadOnly =
    zio.aws.guardduty.model.BlockPublicAccess.wrap(buildAwsValue())
}
object BlockPublicAccess {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.BlockPublicAccess
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.BlockPublicAccess =
      zio.aws.guardduty.model.BlockPublicAccess(
        ignorePublicAcls.map(value => value),
        restrictPublicBuckets.map(value => value),
        blockPublicAcls.map(value => value),
        blockPublicPolicy.map(value => value)
      )
    def ignorePublicAcls: Optional[Boolean]
    def restrictPublicBuckets: Optional[Boolean]
    def blockPublicAcls: Optional[Boolean]
    def blockPublicPolicy: Optional[Boolean]
    def getIgnorePublicAcls: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ignorePublicAcls", ignorePublicAcls)
    def getRestrictPublicBuckets: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("restrictPublicBuckets", restrictPublicBuckets)
    def getBlockPublicAcls: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("blockPublicAcls", blockPublicAcls)
    def getBlockPublicPolicy: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("blockPublicPolicy", blockPublicPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.BlockPublicAccess
  ) extends zio.aws.guardduty.model.BlockPublicAccess.ReadOnly {
    override val ignorePublicAcls: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ignorePublicAcls())
      .map(value => value: Boolean)
    override val restrictPublicBuckets: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.restrictPublicBuckets())
        .map(value => value: Boolean)
    override val blockPublicAcls: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.blockPublicAcls())
      .map(value => value: Boolean)
    override val blockPublicPolicy: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.blockPublicPolicy())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.BlockPublicAccess
  ): zio.aws.guardduty.model.BlockPublicAccess.ReadOnly = new Wrapper(impl)
}
