package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BucketLevelPermissions(
    accessControlList: Optional[zio.aws.guardduty.model.AccessControlList] =
      Optional.Absent,
    bucketPolicy: Optional[zio.aws.guardduty.model.BucketPolicy] =
      Optional.Absent,
    blockPublicAccess: Optional[zio.aws.guardduty.model.BlockPublicAccess] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.BucketLevelPermissions = {
    import BucketLevelPermissions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.BucketLevelPermissions
      .builder()
      .optionallyWith(accessControlList.map(value => value.buildAwsValue()))(
        _.accessControlList
      )
      .optionallyWith(bucketPolicy.map(value => value.buildAwsValue()))(
        _.bucketPolicy
      )
      .optionallyWith(blockPublicAccess.map(value => value.buildAwsValue()))(
        _.blockPublicAccess
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.BucketLevelPermissions.ReadOnly =
    zio.aws.guardduty.model.BucketLevelPermissions.wrap(buildAwsValue())
}
object BucketLevelPermissions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.BucketLevelPermissions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.BucketLevelPermissions =
      zio.aws.guardduty.model.BucketLevelPermissions(
        accessControlList.map(value => value.asEditable),
        bucketPolicy.map(value => value.asEditable),
        blockPublicAccess.map(value => value.asEditable)
      )
    def accessControlList
        : Optional[zio.aws.guardduty.model.AccessControlList.ReadOnly]
    def bucketPolicy: Optional[zio.aws.guardduty.model.BucketPolicy.ReadOnly]
    def blockPublicAccess
        : Optional[zio.aws.guardduty.model.BlockPublicAccess.ReadOnly]
    def getAccessControlList: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.AccessControlList.ReadOnly
    ] = AwsError.unwrapOptionField("accessControlList", accessControlList)
    def getBucketPolicy
        : ZIO[Any, AwsError, zio.aws.guardduty.model.BucketPolicy.ReadOnly] =
      AwsError.unwrapOptionField("bucketPolicy", bucketPolicy)
    def getBlockPublicAccess: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.BlockPublicAccess.ReadOnly
    ] = AwsError.unwrapOptionField("blockPublicAccess", blockPublicAccess)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.BucketLevelPermissions
  ) extends zio.aws.guardduty.model.BucketLevelPermissions.ReadOnly {
    override val accessControlList
        : Optional[zio.aws.guardduty.model.AccessControlList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessControlList())
        .map(value => zio.aws.guardduty.model.AccessControlList.wrap(value))
    override val bucketPolicy
        : Optional[zio.aws.guardduty.model.BucketPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bucketPolicy())
        .map(value => zio.aws.guardduty.model.BucketPolicy.wrap(value))
    override val blockPublicAccess
        : Optional[zio.aws.guardduty.model.BlockPublicAccess.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockPublicAccess())
        .map(value => zio.aws.guardduty.model.BlockPublicAccess.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.BucketLevelPermissions
  ): zio.aws.guardduty.model.BucketLevelPermissions.ReadOnly = new Wrapper(impl)
}
