package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class City(cityName: Optional[String] = Optional.Absent) {
  def buildAwsValue(): software.amazon.awssdk.services.guardduty.model.City = {
    import City.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.City
      .builder()
      .optionallyWith(cityName.map(value => value: java.lang.String))(
        _.cityName
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.City.ReadOnly =
    zio.aws.guardduty.model.City.wrap(buildAwsValue())
}
object City {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.guardduty.model.City] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.City =
      zio.aws.guardduty.model.City(cityName.map(value => value))
    def cityName: Optional[String]
    def getCityName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cityName", cityName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.City
  ) extends zio.aws.guardduty.model.City.ReadOnly {
    override val cityName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cityName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.City
  ): zio.aws.guardduty.model.City.ReadOnly = new Wrapper(impl)
}
