package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CloudTrailConfigurationResult(
    status: zio.aws.guardduty.model.DataSourceStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.CloudTrailConfigurationResult = {
    import CloudTrailConfigurationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.CloudTrailConfigurationResult
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.CloudTrailConfigurationResult.ReadOnly =
    zio.aws.guardduty.model.CloudTrailConfigurationResult.wrap(buildAwsValue())
}
object CloudTrailConfigurationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.CloudTrailConfigurationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.CloudTrailConfigurationResult =
      zio.aws.guardduty.model.CloudTrailConfigurationResult(status)
    def status: zio.aws.guardduty.model.DataSourceStatus
    def getStatus: ZIO[Any, Nothing, zio.aws.guardduty.model.DataSourceStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.CloudTrailConfigurationResult
  ) extends zio.aws.guardduty.model.CloudTrailConfigurationResult.ReadOnly {
    override val status: zio.aws.guardduty.model.DataSourceStatus =
      zio.aws.guardduty.model.DataSourceStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.CloudTrailConfigurationResult
  ): zio.aws.guardduty.model.CloudTrailConfigurationResult.ReadOnly =
    new Wrapper(impl)
}
