package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class Condition(
    eq: Optional[Iterable[String]] = Optional.Absent,
    neq: Optional[Iterable[String]] = Optional.Absent,
    gt: Optional[Integer] = Optional.Absent,
    gte: Optional[Integer] = Optional.Absent,
    lt: Optional[Integer] = Optional.Absent,
    lte: Optional[Integer] = Optional.Absent,
    equalsValue: Optional[Iterable[String]] = Optional.Absent,
    notEquals: Optional[Iterable[String]] = Optional.Absent,
    greaterThan: Optional[Long] = Optional.Absent,
    greaterThanOrEqual: Optional[Long] = Optional.Absent,
    lessThan: Optional[Long] = Optional.Absent,
    lessThanOrEqual: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.Condition = {
    import Condition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.Condition
      .builder()
      .optionallyWith(
        eq.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eq)
      .optionallyWith(
        neq.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.neq)
      .optionallyWith(gt.map(value => value: java.lang.Integer))(_.gt)
      .optionallyWith(gte.map(value => value: java.lang.Integer))(_.gte)
      .optionallyWith(lt.map(value => value: java.lang.Integer))(_.lt)
      .optionallyWith(lte.map(value => value: java.lang.Integer))(_.lte)
      .optionallyWith(
        equalsValue.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.equalsValue)
      .optionallyWith(
        notEquals.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.notEquals)
      .optionallyWith(greaterThan.map(value => value: java.lang.Long))(
        _.greaterThan
      )
      .optionallyWith(greaterThanOrEqual.map(value => value: java.lang.Long))(
        _.greaterThanOrEqual
      )
      .optionallyWith(lessThan.map(value => value: java.lang.Long))(_.lessThan)
      .optionallyWith(lessThanOrEqual.map(value => value: java.lang.Long))(
        _.lessThanOrEqual
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.Condition.ReadOnly =
    zio.aws.guardduty.model.Condition.wrap(buildAwsValue())
}
object Condition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.Condition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.Condition =
      zio.aws.guardduty.model.Condition(
        eq.map(value => value),
        neq.map(value => value),
        gt.map(value => value),
        gte.map(value => value),
        lt.map(value => value),
        lte.map(value => value),
        equalsValue.map(value => value),
        notEquals.map(value => value),
        greaterThan.map(value => value),
        greaterThanOrEqual.map(value => value),
        lessThan.map(value => value),
        lessThanOrEqual.map(value => value)
      )
    def eq: Optional[List[String]]
    def neq: Optional[List[String]]
    def gt: Optional[Integer]
    def gte: Optional[Integer]
    def lt: Optional[Integer]
    def lte: Optional[Integer]
    def equalsValue: Optional[List[String]]
    def notEquals: Optional[List[String]]
    def greaterThan: Optional[Long]
    def greaterThanOrEqual: Optional[Long]
    def lessThan: Optional[Long]
    def lessThanOrEqual: Optional[Long]
    def getEq: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eq", eq)
    def getNeq: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("neq", neq)
    def getGt: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("gt", gt)
    def getGte: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("gte", gte)
    def getLt: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("lt", lt)
    def getLte: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("lte", lte)
    def getEqualsValue: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("equalsValue", equalsValue)
    def getNotEquals: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("notEquals", notEquals)
    def getGreaterThan: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("greaterThan", greaterThan)
    def getGreaterThanOrEqual: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("greaterThanOrEqual", greaterThanOrEqual)
    def getLessThan: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("lessThan", lessThan)
    def getLessThanOrEqual: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("lessThanOrEqual", lessThanOrEqual)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.Condition
  ) extends zio.aws.guardduty.model.Condition.ReadOnly {
    override val eq: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.eq())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val neq: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.neq())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val gt: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.gt())
      .map(value => value: Integer)
    override val gte: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.gte())
      .map(value => value: Integer)
    override val lt: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.lt())
      .map(value => value: Integer)
    override val lte: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.lte())
      .map(value => value: Integer)
    override val equalsValue: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.equalsValue())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val notEquals: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.notEquals())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val greaterThan: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.greaterThan())
      .map(value => value: Long)
    override val greaterThanOrEqual: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.greaterThanOrEqual())
      .map(value => value: Long)
    override val lessThan: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.lessThan())
      .map(value => value: Long)
    override val lessThanOrEqual: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.lessThanOrEqual())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.Condition
  ): zio.aws.guardduty.model.Condition.ReadOnly = new Wrapper(impl)
}
