package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Container(
    containerRuntime: Optional[String] = Optional.Absent,
    id: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    image: Optional[String] = Optional.Absent,
    imagePrefix: Optional[String] = Optional.Absent,
    volumeMounts: Optional[Iterable[zio.aws.guardduty.model.VolumeMount]] =
      Optional.Absent,
    securityContext: Optional[zio.aws.guardduty.model.SecurityContext] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.Container = {
    import Container.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.Container
      .builder()
      .optionallyWith(containerRuntime.map(value => value: java.lang.String))(
        _.containerRuntime
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(image.map(value => value: java.lang.String))(_.image)
      .optionallyWith(imagePrefix.map(value => value: java.lang.String))(
        _.imagePrefix
      )
      .optionallyWith(
        volumeMounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumeMounts)
      .optionallyWith(securityContext.map(value => value.buildAwsValue()))(
        _.securityContext
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.Container.ReadOnly =
    zio.aws.guardduty.model.Container.wrap(buildAwsValue())
}
object Container {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.Container
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.Container =
      zio.aws.guardduty.model.Container(
        containerRuntime.map(value => value),
        id.map(value => value),
        name.map(value => value),
        image.map(value => value),
        imagePrefix.map(value => value),
        volumeMounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        securityContext.map(value => value.asEditable)
      )
    def containerRuntime: Optional[String]
    def id: Optional[String]
    def name: Optional[String]
    def image: Optional[String]
    def imagePrefix: Optional[String]
    def volumeMounts
        : Optional[List[zio.aws.guardduty.model.VolumeMount.ReadOnly]]
    def securityContext
        : Optional[zio.aws.guardduty.model.SecurityContext.ReadOnly]
    def getContainerRuntime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerRuntime", containerRuntime)
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getImage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("image", image)
    def getImagePrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imagePrefix", imagePrefix)
    def getVolumeMounts: ZIO[Any, AwsError, List[
      zio.aws.guardduty.model.VolumeMount.ReadOnly
    ]] = AwsError.unwrapOptionField("volumeMounts", volumeMounts)
    def getSecurityContext
        : ZIO[Any, AwsError, zio.aws.guardduty.model.SecurityContext.ReadOnly] =
      AwsError.unwrapOptionField("securityContext", securityContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.Container
  ) extends zio.aws.guardduty.model.Container.ReadOnly {
    override val containerRuntime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.containerRuntime())
      .map(value => value: String)
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val image: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.image())
      .map(value => value: String)
    override val imagePrefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imagePrefix())
      .map(value => value: String)
    override val volumeMounts
        : Optional[List[zio.aws.guardduty.model.VolumeMount.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeMounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.VolumeMount.wrap(item)
          }.toList
        )
    override val securityContext
        : Optional[zio.aws.guardduty.model.SecurityContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityContext())
        .map(value => zio.aws.guardduty.model.SecurityContext.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.Container
  ): zio.aws.guardduty.model.Container.ReadOnly = new Wrapper(impl)
}
