package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Country(
    countryCode: Optional[String] = Optional.Absent,
    countryName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.Country = {
    import Country.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.Country
      .builder()
      .optionallyWith(countryCode.map(value => value: java.lang.String))(
        _.countryCode
      )
      .optionallyWith(countryName.map(value => value: java.lang.String))(
        _.countryName
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.Country.ReadOnly =
    zio.aws.guardduty.model.Country.wrap(buildAwsValue())
}
object Country {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.guardduty.model.Country] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.Country = zio.aws.guardduty.model
      .Country(countryCode.map(value => value), countryName.map(value => value))
    def countryCode: Optional[String]
    def countryName: Optional[String]
    def getCountryCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("countryCode", countryCode)
    def getCountryName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("countryName", countryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.Country
  ) extends zio.aws.guardduty.model.Country.ReadOnly {
    override val countryCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.countryCode())
      .map(value => value: String)
    override val countryName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.countryName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.Country
  ): zio.aws.guardduty.model.Country.ReadOnly = new Wrapper(impl)
}
