package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.{TagValue, TagKey, ClientToken}
import scala.jdk.CollectionConverters.*
final case class CreateDetectorRequest(
    enable: Boolean,
    clientToken: Optional[ClientToken] = Optional.Absent,
    findingPublishingFrequency: Optional[
      zio.aws.guardduty.model.FindingPublishingFrequency
    ] = Optional.Absent,
    dataSources: Optional[zio.aws.guardduty.model.DataSourceConfigurations] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.CreateDetectorRequest = {
    import CreateDetectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.CreateDetectorRequest
      .builder()
      .enable(enable: java.lang.Boolean)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(findingPublishingFrequency.map(value => value.unwrap))(
        _.findingPublishingFrequency
      )
      .optionallyWith(dataSources.map(value => value.buildAwsValue()))(
        _.dataSources
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.CreateDetectorRequest.ReadOnly =
    zio.aws.guardduty.model.CreateDetectorRequest.wrap(buildAwsValue())
}
object CreateDetectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.CreateDetectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.CreateDetectorRequest =
      zio.aws.guardduty.model.CreateDetectorRequest(
        enable,
        clientToken.map(value => value),
        findingPublishingFrequency.map(value => value),
        dataSources.map(value => value.asEditable),
        tags.map(value => value)
      )
    def enable: Boolean
    def clientToken: Optional[ClientToken]
    def findingPublishingFrequency
        : Optional[zio.aws.guardduty.model.FindingPublishingFrequency]
    def dataSources
        : Optional[zio.aws.guardduty.model.DataSourceConfigurations.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getEnable: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enable)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFindingPublishingFrequency: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.FindingPublishingFrequency
    ] = AwsError.unwrapOptionField(
      "findingPublishingFrequency",
      findingPublishingFrequency
    )
    def getDataSources: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.DataSourceConfigurations.ReadOnly
    ] = AwsError.unwrapOptionField("dataSources", dataSources)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.CreateDetectorRequest
  ) extends zio.aws.guardduty.model.CreateDetectorRequest.ReadOnly {
    override val enable: Boolean = impl.enable(): Boolean
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.guardduty.model.primitives.ClientToken(value))
    override val findingPublishingFrequency
        : Optional[zio.aws.guardduty.model.FindingPublishingFrequency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingPublishingFrequency())
        .map(value =>
          zio.aws.guardduty.model.FindingPublishingFrequency.wrap(value)
        )
    override val dataSources
        : Optional[zio.aws.guardduty.model.DataSourceConfigurations.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSources())
        .map(value =>
          zio.aws.guardduty.model.DataSourceConfigurations.wrap(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.guardduty.model.primitives
              .TagKey(key) -> zio.aws.guardduty.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.CreateDetectorRequest
  ): zio.aws.guardduty.model.CreateDetectorRequest.ReadOnly = new Wrapper(impl)
}
