package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.DetectorId
import scala.jdk.CollectionConverters.*
final case class CreateDetectorResponse(
    detectorId: Optional[DetectorId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.CreateDetectorResponse = {
    import CreateDetectorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.CreateDetectorResponse
      .builder()
      .optionallyWith(
        detectorId.map(value => DetectorId.unwrap(value): java.lang.String)
      )(_.detectorId)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.CreateDetectorResponse.ReadOnly =
    zio.aws.guardduty.model.CreateDetectorResponse.wrap(buildAwsValue())
}
object CreateDetectorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.CreateDetectorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.CreateDetectorResponse =
      zio.aws.guardduty.model
        .CreateDetectorResponse(detectorId.map(value => value))
    def detectorId: Optional[DetectorId]
    def getDetectorId: ZIO[Any, AwsError, DetectorId] =
      AwsError.unwrapOptionField("detectorId", detectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.CreateDetectorResponse
  ) extends zio.aws.guardduty.model.CreateDetectorResponse.ReadOnly {
    override val detectorId: Optional[DetectorId] = zio.aws.core.internal
      .optionalFromNullable(impl.detectorId())
      .map(value => zio.aws.guardduty.model.primitives.DetectorId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.CreateDetectorResponse
  ): zio.aws.guardduty.model.CreateDetectorResponse.ReadOnly = new Wrapper(impl)
}
