package zio.aws.guardduty.model
import zio.aws.guardduty.model.primitives.{
  FilterName,
  DetectorId,
  FilterDescription,
  TagValue,
  FilterRank,
  ClientToken,
  TagKey
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateFilterRequest(
    detectorId: DetectorId,
    name: FilterName,
    description: Optional[FilterDescription] = Optional.Absent,
    action: Optional[zio.aws.guardduty.model.FilterAction] = Optional.Absent,
    rank: Optional[FilterRank] = Optional.Absent,
    findingCriteria: zio.aws.guardduty.model.FindingCriteria,
    clientToken: Optional[ClientToken] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.CreateFilterRequest = {
    import CreateFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.CreateFilterRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .name(FilterName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          FilterDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(rank.map(value => FilterRank.unwrap(value): Integer))(
        _.rank
      )
      .findingCriteria(findingCriteria.buildAwsValue())
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.CreateFilterRequest.ReadOnly =
    zio.aws.guardduty.model.CreateFilterRequest.wrap(buildAwsValue())
}
object CreateFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.CreateFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.CreateFilterRequest =
      zio.aws.guardduty.model.CreateFilterRequest(
        detectorId,
        name,
        description.map(value => value),
        action.map(value => value),
        rank.map(value => value),
        findingCriteria.asEditable,
        clientToken.map(value => value),
        tags.map(value => value)
      )
    def detectorId: DetectorId
    def name: FilterName
    def description: Optional[FilterDescription]
    def action: Optional[zio.aws.guardduty.model.FilterAction]
    def rank: Optional[FilterRank]
    def findingCriteria: zio.aws.guardduty.model.FindingCriteria.ReadOnly
    def clientToken: Optional[ClientToken]
    def tags: Optional[Map[TagKey, TagValue]]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getName: ZIO[Any, Nothing, FilterName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, FilterDescription] =
      AwsError.unwrapOptionField("description", description)
    def getAction: ZIO[Any, AwsError, zio.aws.guardduty.model.FilterAction] =
      AwsError.unwrapOptionField("action", action)
    def getRank: ZIO[Any, AwsError, FilterRank] =
      AwsError.unwrapOptionField("rank", rank)
    def getFindingCriteria
        : ZIO[Any, Nothing, zio.aws.guardduty.model.FindingCriteria.ReadOnly] =
      ZIO.succeed(findingCriteria)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.CreateFilterRequest
  ) extends zio.aws.guardduty.model.CreateFilterRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val name: FilterName =
      zio.aws.guardduty.model.primitives.FilterName(impl.name())
    override val description: Optional[FilterDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.guardduty.model.primitives.FilterDescription(value)
        )
    override val action: Optional[zio.aws.guardduty.model.FilterAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.guardduty.model.FilterAction.wrap(value))
    override val rank: Optional[FilterRank] = zio.aws.core.internal
      .optionalFromNullable(impl.rank())
      .map(value => zio.aws.guardduty.model.primitives.FilterRank(value))
    override val findingCriteria
        : zio.aws.guardduty.model.FindingCriteria.ReadOnly =
      zio.aws.guardduty.model.FindingCriteria.wrap(impl.findingCriteria())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.guardduty.model.primitives.ClientToken(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.guardduty.model.primitives
              .TagKey(key) -> zio.aws.guardduty.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.CreateFilterRequest
  ): zio.aws.guardduty.model.CreateFilterRequest.ReadOnly = new Wrapper(impl)
}
