package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.FilterName
import scala.jdk.CollectionConverters.*
final case class CreateFilterResponse(name: FilterName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.CreateFilterResponse = {
    import CreateFilterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.CreateFilterResponse
      .builder()
      .name(FilterName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.CreateFilterResponse.ReadOnly =
    zio.aws.guardduty.model.CreateFilterResponse.wrap(buildAwsValue())
}
object CreateFilterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.CreateFilterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.CreateFilterResponse =
      zio.aws.guardduty.model.CreateFilterResponse(name)
    def name: FilterName
    def getName: ZIO[Any, Nothing, FilterName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.CreateFilterResponse
  ) extends zio.aws.guardduty.model.CreateFilterResponse.ReadOnly {
    override val name: FilterName =
      zio.aws.guardduty.model.primitives.FilterName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.CreateFilterResponse
  ): zio.aws.guardduty.model.CreateFilterResponse.ReadOnly = new Wrapper(impl)
}
